package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyEventSubscriptionRequest(
    subscriptionName: String,
    snsTopicArn: Optional[String] = Optional.Absent,
    sourceType: Optional[String] = Optional.Absent,
    sourceIds: Optional[Iterable[String]] = Optional.Absent,
    eventCategories: Optional[Iterable[String]] = Optional.Absent,
    severity: Optional[String] = Optional.Absent,
    enabled: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest = {
    import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIds)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyEventSubscriptionRequest.ReadOnly =
    zio.aws.redshift.model.ModifyEventSubscriptionRequest.wrap(buildAwsValue())
}
object ModifyEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyEventSubscriptionRequest =
      zio.aws.redshift.model.ModifyEventSubscriptionRequest(
        subscriptionName,
        snsTopicArn.map(value => value),
        sourceType.map(value => value),
        sourceIds.map(value => value),
        eventCategories.map(value => value),
        severity.map(value => value),
        enabled.map(value => value)
      )
    def subscriptionName: String
    def snsTopicArn: Optional[String]
    def sourceType: Optional[String]
    def sourceIds: Optional[List[String]]
    def eventCategories: Optional[List[String]]
    def severity: Optional[String]
    def enabled: Optional[BooleanOptional]
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIds", sourceIds)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest
  ) extends zio.aws.redshift.model.ModifyEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val sourceIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategories: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val severity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => value: String)
    override val enabled: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest
  ): zio.aws.redshift.model.ModifyEventSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
