package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyClusterSubnetGroupRequest(
    clusterSubnetGroupName: String,
    description: Optional[String] = Optional.Absent,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest = {
    import ModifyClusterSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest
      .builder()
      .clusterSubnetGroupName(clusterSubnetGroupName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterSubnetGroupRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSubnetGroupRequest.wrap(buildAwsValue())
}
object ModifyClusterSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterSubnetGroupRequest =
      zio.aws.redshift.model.ModifyClusterSubnetGroupRequest(
        clusterSubnetGroupName,
        description.map(value => value),
        subnetIds
      )
    def clusterSubnetGroupName: String
    def description: Optional[String]
    def subnetIds: List[String]
    def getClusterSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSubnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest
  ) extends zio.aws.redshift.model.ModifyClusterSubnetGroupRequest.ReadOnly {
    override val clusterSubnetGroupName: String =
      impl.clusterSubnetGroupName(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest
  ): zio.aws.redshift.model.ModifyClusterSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
