package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModifyAuthenticationProfileRequest(
    authenticationProfileName: AuthenticationProfileNameString,
    authenticationProfileContent: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest = {
    import ModifyAuthenticationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest
      .builder()
      .authenticationProfileName(
        AuthenticationProfileNameString.unwrap(
          authenticationProfileName
        ): java.lang.String
      )
      .authenticationProfileContent(
        authenticationProfileContent: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyAuthenticationProfileRequest.ReadOnly =
    zio.aws.redshift.model.ModifyAuthenticationProfileRequest
      .wrap(buildAwsValue())
}
object ModifyAuthenticationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyAuthenticationProfileRequest =
      zio.aws.redshift.model.ModifyAuthenticationProfileRequest(
        authenticationProfileName,
        authenticationProfileContent
      )
    def authenticationProfileName: AuthenticationProfileNameString
    def authenticationProfileContent: String
    def getAuthenticationProfileName
        : ZIO[Any, Nothing, AuthenticationProfileNameString] =
      ZIO.succeed(authenticationProfileName)
    def getAuthenticationProfileContent: ZIO[Any, Nothing, String] =
      ZIO.succeed(authenticationProfileContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest
  ) extends zio.aws.redshift.model.ModifyAuthenticationProfileRequest.ReadOnly {
    override val authenticationProfileName: AuthenticationProfileNameString =
      zio.aws.redshift.model.primitives
        .AuthenticationProfileNameString(impl.authenticationProfileName())
    override val authenticationProfileContent: String =
      impl.authenticationProfileContent(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest
  ): zio.aws.redshift.model.ModifyAuthenticationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
