package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{TStamp, SensitiveString}
import scala.jdk.CollectionConverters.*
final case class GetClusterCredentialsWithIamResponse(
    dbUser: Optional[String] = Optional.Absent,
    dbPassword: Optional[SensitiveString] = Optional.Absent,
    expiration: Optional[TStamp] = Optional.Absent,
    nextRefreshTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse = {
    import GetClusterCredentialsWithIamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse
      .builder()
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        dbPassword.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.dbPassword)
      .optionallyWith(expiration.map(value => TStamp.unwrap(value): Instant))(
        _.expiration
      )
      .optionallyWith(
        nextRefreshTime.map(value => TStamp.unwrap(value): Instant)
      )(_.nextRefreshTime)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetClusterCredentialsWithIamResponse.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsWithIamResponse
      .wrap(buildAwsValue())
}
object GetClusterCredentialsWithIamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.GetClusterCredentialsWithIamResponse =
      zio.aws.redshift.model.GetClusterCredentialsWithIamResponse(
        dbUser.map(value => value),
        dbPassword.map(value => value),
        expiration.map(value => value),
        nextRefreshTime.map(value => value)
      )
    def dbUser: Optional[String]
    def dbPassword: Optional[SensitiveString]
    def expiration: Optional[TStamp]
    def nextRefreshTime: Optional[TStamp]
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getDbPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("dbPassword", dbPassword)
    def getExpiration: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getNextRefreshTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nextRefreshTime", nextRefreshTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse
  ) extends zio.aws.redshift.model.GetClusterCredentialsWithIamResponse.ReadOnly {
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val dbPassword: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbPassword())
      .map(value => zio.aws.redshift.model.primitives.SensitiveString(value))
    override val expiration: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val nextRefreshTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.nextRefreshTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse
  ): zio.aws.redshift.model.GetClusterCredentialsWithIamResponse.ReadOnly =
    new Wrapper(impl)
}
