package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteClusterSecurityGroupRequest(
    clusterSecurityGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest = {
    import DeleteClusterSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest
      .builder()
      .clusterSecurityGroupName(clusterSecurityGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteClusterSecurityGroupRequest.ReadOnly =
    zio.aws.redshift.model.DeleteClusterSecurityGroupRequest
      .wrap(buildAwsValue())
}
object DeleteClusterSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterSecurityGroupRequest =
      zio.aws.redshift.model
        .DeleteClusterSecurityGroupRequest(clusterSecurityGroupName)
    def clusterSecurityGroupName: String
    def getClusterSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSecurityGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest
  ) extends zio.aws.redshift.model.DeleteClusterSecurityGroupRequest.ReadOnly {
    override val clusterSecurityGroupName: String =
      impl.clusterSecurityGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest
  ): zio.aws.redshift.model.DeleteClusterSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
