package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotSchedulesRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    scheduleIdentifier: Optional[String] = Optional.Absent,
    tagKeys: Optional[Iterable[String]] = Optional.Absent,
    tagValues: Optional[Iterable[String]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest = {
    import DescribeSnapshotSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeSnapshotSchedulesRequest
      .wrap(buildAwsValue())
}
object DescribeSnapshotSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeSnapshotSchedulesRequest =
      zio.aws.redshift.model.DescribeSnapshotSchedulesRequest(
        clusterIdentifier.map(value => value),
        scheduleIdentifier.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def scheduleIdentifier: Optional[String]
    def tagKeys: Optional[List[String]]
    def tagValues: Optional[List[String]]
    def marker: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ) extends zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val scheduleIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleIdentifier())
      .map(value => value: String)
    override val tagKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest
  ): zio.aws.redshift.model.DescribeSnapshotSchedulesRequest.ReadOnly =
    new Wrapper(impl)
}
