package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeClusterParametersResponse(
    parameters: Optional[Iterable[zio.aws.redshift.model.Parameter]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse = {
    import DescribeClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterParametersResponse =
      zio.aws.redshift.model.DescribeClusterParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: Optional[List[zio.aws.redshift.model.Parameter.ReadOnly]]
    def marker: Optional[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse
  ) extends zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly {
    override val parameters
        : Optional[List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Parameter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse
  ): zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
