package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeletePartnerResponse(
    databaseName: Optional[PartnerIntegrationDatabaseName] = Optional.Absent,
    partnerName: Optional[PartnerIntegrationPartnerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeletePartnerResponse = {
    import DeletePartnerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeletePartnerResponse.ReadOnly =
    zio.aws.redshift.model.DeletePartnerResponse.wrap(buildAwsValue())
}
object DeletePartnerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeletePartnerResponse =
      zio.aws.redshift.model.DeletePartnerResponse(
        databaseName.map(value => value),
        partnerName.map(value => value)
      )
    def databaseName: Optional[PartnerIntegrationDatabaseName]
    def partnerName: Optional[PartnerIntegrationPartnerName]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ) extends zio.aws.redshift.model.DeletePartnerResponse.ReadOnly {
    override val databaseName: Optional[PartnerIntegrationDatabaseName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseName())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationDatabaseName(value)
        )
    override val partnerName: Optional[PartnerIntegrationPartnerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partnerName())
        .map(value =>
          zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerResponse
  ): zio.aws.redshift.model.DeletePartnerResponse.ReadOnly = new Wrapper(impl)
}
