package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.redshift.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ActionType
  ): zio.aws.redshift.model.ActionType = value match {
    case software.amazon.awssdk.services.redshift.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ActionType.RESTORE_CLUSTER =>
      val r = `restore-cluster`
      r
    case software.amazon.awssdk.services.redshift.model.ActionType.RECOMMEND_NODE_CONFIG =>
      val r = `recommend-node-config`
      r
    case software.amazon.awssdk.services.redshift.model.ActionType.RESIZE_CLUSTER =>
      val r = `resize-cluster`
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ActionType =
      software.amazon.awssdk.services.redshift.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object `restore-cluster` extends zio.aws.redshift.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ActionType =
      software.amazon.awssdk.services.redshift.model.ActionType.RESTORE_CLUSTER
  }
  case object `recommend-node-config`
      extends zio.aws.redshift.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ActionType =
      software.amazon.awssdk.services.redshift.model.ActionType.RECOMMEND_NODE_CONFIG
  }
  case object `resize-cluster` extends zio.aws.redshift.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ActionType =
      software.amazon.awssdk.services.redshift.model.ActionType.RESIZE_CLUSTER
  }
}
