package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedNodeOfferingResponse(
    reservedNode: Optional[zio.aws.redshift.model.ReservedNode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse = {
    import PurchaseReservedNodeOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse
      .builder()
      .optionallyWith(reservedNode.map(value => value.buildAwsValue()))(
        _.reservedNode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly =
    zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedNodeOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse =
      zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse(
        reservedNode.map(value => value.asEditable)
      )
    def reservedNode: Optional[zio.aws.redshift.model.ReservedNode.ReadOnly]
    def getReservedNode
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly] =
      AwsError.unwrapOptionField("reservedNode", reservedNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse
  ) extends zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly {
    override val reservedNode
        : Optional[zio.aws.redshift.model.ReservedNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNode())
        .map(value => zio.aws.redshift.model.ReservedNode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse
  ): zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
