package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, TStamp}
import scala.jdk.CollectionConverters.*
final case class ModifyScheduledActionRequest(
    scheduledActionName: String,
    targetAction: Optional[zio.aws.redshift.model.ScheduledActionType] =
      Optional.Absent,
    schedule: Optional[String] = Optional.Absent,
    iamRole: Optional[String] = Optional.Absent,
    scheduledActionDescription: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent,
    enable: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest = {
    import ModifyScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
      .builder()
      .scheduledActionName(scheduledActionName: java.lang.String)
      .optionallyWith(targetAction.map(value => value.buildAwsValue()))(
        _.targetAction
      )
      .optionallyWith(schedule.map(value => value: java.lang.String))(
        _.schedule
      )
      .optionallyWith(iamRole.map(value => value: java.lang.String))(_.iamRole)
      .optionallyWith(
        scheduledActionDescription.map(value => value: java.lang.String)
      )(_.scheduledActionDescription)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(enable.map(value => value: java.lang.Boolean))(_.enable)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly =
    zio.aws.redshift.model.ModifyScheduledActionRequest.wrap(buildAwsValue())
}
object ModifyScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyScheduledActionRequest =
      zio.aws.redshift.model.ModifyScheduledActionRequest(
        scheduledActionName,
        targetAction.map(value => value.asEditable),
        schedule.map(value => value),
        iamRole.map(value => value),
        scheduledActionDescription.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        enable.map(value => value)
      )
    def scheduledActionName: String
    def targetAction
        : Optional[zio.aws.redshift.model.ScheduledActionType.ReadOnly]
    def schedule: Optional[String]
    def iamRole: Optional[String]
    def scheduledActionDescription: Optional[String]
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def enable: Optional[BooleanOptional]
    def getScheduledActionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(scheduledActionName)
    def getTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ScheduledActionType.ReadOnly
    ] = AwsError.unwrapOptionField("targetAction", targetAction)
    def getSchedule: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getIamRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getScheduledActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "scheduledActionDescription",
        scheduledActionDescription
      )
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEnable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enable", enable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ) extends zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly {
    override val scheduledActionName: String =
      impl.scheduledActionName(): String
    override val targetAction
        : Optional[zio.aws.redshift.model.ScheduledActionType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetAction())
        .map(value => zio.aws.redshift.model.ScheduledActionType.wrap(value))
    override val schedule: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value => value: String)
    override val iamRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => value: String)
    override val scheduledActionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledActionDescription())
        .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val enable: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.enable())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest
  ): zio.aws.redshift.model.ModifyScheduledActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
