package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUsageLimitResponse(
    usageLimitId: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    featureType: Optional[zio.aws.redshift.model.UsageLimitFeatureType] =
      Optional.Absent,
    limitType: Optional[zio.aws.redshift.model.UsageLimitLimitType] =
      Optional.Absent,
    amount: Optional[Long] = Optional.Absent,
    period: Optional[zio.aws.redshift.model.UsageLimitPeriod] = Optional.Absent,
    breachAction: Optional[zio.aws.redshift.model.UsageLimitBreachAction] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse = {
    import CreateUsageLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse
      .builder()
      .optionallyWith(usageLimitId.map(value => value: java.lang.String))(
        _.usageLimitId
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .optionallyWith(limitType.map(value => value.unwrap))(_.limitType)
      .optionallyWith(amount.map(value => value: java.lang.Long))(_.amount)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly =
    zio.aws.redshift.model.CreateUsageLimitResponse.wrap(buildAwsValue())
}
object CreateUsageLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateUsageLimitResponse =
      zio.aws.redshift.model.CreateUsageLimitResponse(
        usageLimitId.map(value => value),
        clusterIdentifier.map(value => value),
        featureType.map(value => value),
        limitType.map(value => value),
        amount.map(value => value),
        period.map(value => value),
        breachAction.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def usageLimitId: Optional[String]
    def clusterIdentifier: Optional[String]
    def featureType: Optional[zio.aws.redshift.model.UsageLimitFeatureType]
    def limitType: Optional[zio.aws.redshift.model.UsageLimitLimitType]
    def amount: Optional[Long]
    def period: Optional[zio.aws.redshift.model.UsageLimitPeriod]
    def breachAction: Optional[zio.aws.redshift.model.UsageLimitBreachAction]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getUsageLimitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageLimitId", usageLimitId)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitFeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
    def getLimitType
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitLimitType] =
      AwsError.unwrapOptionField("limitType", limitType)
    def getAmount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amount", amount)
    def getPeriod: ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getBreachAction
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitBreachAction] =
      AwsError.unwrapOptionField("breachAction", breachAction)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse
  ) extends zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly {
    override val usageLimitId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageLimitId())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val featureType
        : Optional[zio.aws.redshift.model.UsageLimitFeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.redshift.model.UsageLimitFeatureType.wrap(value))
    override val limitType
        : Optional[zio.aws.redshift.model.UsageLimitLimitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limitType())
        .map(value => zio.aws.redshift.model.UsageLimitLimitType.wrap(value))
    override val amount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: Long)
    override val period: Optional[zio.aws.redshift.model.UsageLimitPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value => zio.aws.redshift.model.UsageLimitPeriod.wrap(value))
    override val breachAction
        : Optional[zio.aws.redshift.model.UsageLimitBreachAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.breachAction())
        .map(value => zio.aws.redshift.model.UsageLimitBreachAction.wrap(value))
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse
  ): zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly = new Wrapper(
    impl
  )
}
