package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterSubnetGroup(
    clusterSubnetGroupName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    subnetGroupStatus: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[zio.aws.redshift.model.Subnet]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup = {
    import ClusterSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
      .builder()
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly =
    zio.aws.redshift.model.ClusterSubnetGroup.wrap(buildAwsValue())
}
object ClusterSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterSubnetGroup =
      zio.aws.redshift.model.ClusterSubnetGroup(
        clusterSubnetGroupName.map(value => value),
        description.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterSubnetGroupName: Optional[String]
    def description: Optional[String]
    def vpcId: Optional[String]
    def subnetGroupStatus: Optional[String]
    def subnets: Optional[List[zio.aws.redshift.model.Subnet.ReadOnly]]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ) extends zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly {
    override val clusterSubnetGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroupName())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnetGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupStatus())
      .map(value => value: String)
    override val subnets
        : Optional[List[zio.aws.redshift.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Subnet.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup
  ): zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly = new Wrapper(impl)
}
