package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TaggedResource(
    tag: Optional[zio.aws.redshift.model.Tag] = Optional.Absent,
    resourceName: Optional[String] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.TaggedResource = {
    import TaggedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.TaggedResource
      .builder()
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.TaggedResource.ReadOnly =
    zio.aws.redshift.model.TaggedResource.wrap(buildAwsValue())
}
object TaggedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.TaggedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.TaggedResource =
      zio.aws.redshift.model.TaggedResource(
        tag.map(value => value.asEditable),
        resourceName.map(value => value),
        resourceType.map(value => value)
      )
    def tag: Optional[zio.aws.redshift.model.Tag.ReadOnly]
    def resourceName: Optional[String]
    def resourceType: Optional[String]
    def getTag: ZIO[Any, AwsError, zio.aws.redshift.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.TaggedResource
  ) extends zio.aws.redshift.model.TaggedResource.ReadOnly {
    override val tag: Optional[zio.aws.redshift.model.Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.redshift.model.Tag.wrap(value))
    override val resourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: String)
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.TaggedResource
  ): zio.aws.redshift.model.TaggedResource.ReadOnly = new Wrapper(impl)
}
