package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResetClusterParameterGroupRequest(
    parameterGroupName: String,
    resetAllParameters: Optional[Boolean] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.redshift.model.Parameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest = {
    import ResetClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(
        resetAllParameters.map(value => value: java.lang.Boolean)
      )(_.resetAllParameters)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly =
    zio.aws.redshift.model.ResetClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object ResetClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResetClusterParameterGroupRequest =
      zio.aws.redshift.model.ResetClusterParameterGroupRequest(
        parameterGroupName,
        resetAllParameters.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: String
    def resetAllParameters: Optional[Boolean]
    def parameters: Optional[List[zio.aws.redshift.model.Parameter.ReadOnly]]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getResetAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetAllParameters", resetAllParameters)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ) extends zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val resetAllParameters: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resetAllParameters())
      .map(value => value: Boolean)
    override val parameters
        : Optional[List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Parameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest
  ): zio.aws.redshift.model.ResetClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
