package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuthorizeClusterSecurityGroupIngressResponse(
    clusterSecurityGroup: Optional[
      zio.aws.redshift.model.ClusterSecurityGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse = {
    import AuthorizeClusterSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
      .builder()
      .optionallyWith(clusterSecurityGroup.map(value => value.buildAwsValue()))(
        _.clusterSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly =
    zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object AuthorizeClusterSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse =
      zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse(
        clusterSecurityGroup.map(value => value.asEditable)
      )
    def clusterSecurityGroup
        : Optional[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]
    def getClusterSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSecurityGroup", clusterSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ) extends zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly {
    override val clusterSecurityGroup
        : Optional[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroup())
        .map(value => zio.aws.redshift.model.ClusterSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ): zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
