package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTagsRequest(
    resourceName: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteTagsRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteTagsRequest.ReadOnly =
    zio.aws.redshift.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteTagsRequest =
      zio.aws.redshift.model.DeleteTagsRequest(resourceName, tagKeys)
    def resourceName: String
    def tagKeys: List[String]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteTagsRequest
  ) extends zio.aws.redshift.model.DeleteTagsRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteTagsRequest
  ): zio.aws.redshift.model.DeleteTagsRequest.ReadOnly = new Wrapper(impl)
}
