package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointAccessRequest(endpointName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest = {
    import DeleteEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.DeleteEndpointAccessRequest.wrap(buildAwsValue())
}
object DeleteEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteEndpointAccessRequest =
      zio.aws.redshift.model.DeleteEndpointAccessRequest(endpointName)
    def endpointName: String
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest
  ) extends zio.aws.redshift.model.DeleteEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest
  ): zio.aws.redshift.model.DeleteEndpointAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
