package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BatchModifyClusterSnapshotsRequest(
    snapshotIdentifierList: Iterable[String],
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest = {
    import BatchModifyClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest
      .builder()
      .snapshotIdentifierList(snapshotIdentifierList.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest.ReadOnly =
    zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest
      .wrap(buildAwsValue())
}
object BatchModifyClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest =
      zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest(
        snapshotIdentifierList,
        manualSnapshotRetentionPeriod.map(value => value),
        force.map(value => value)
      )
    def snapshotIdentifierList: List[String]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def force: Optional[Boolean]
    def getSnapshotIdentifierList: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(snapshotIdentifierList)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest
  ) extends zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest.ReadOnly {
    override val snapshotIdentifierList: List[String] = impl
      .snapshotIdentifierList()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest
  ): zio.aws.redshift.model.BatchModifyClusterSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
