package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReservedNodeConfigurationOption(
    sourceReservedNode: Optional[zio.aws.redshift.model.ReservedNode] =
      Optional.Absent,
    targetReservedNodeCount: Optional[Integer] = Optional.Absent,
    targetReservedNodeOffering: Optional[
      zio.aws.redshift.model.ReservedNodeOffering
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption = {
    import ReservedNodeConfigurationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
      .builder()
      .optionallyWith(sourceReservedNode.map(value => value.buildAwsValue()))(
        _.sourceReservedNode
      )
      .optionallyWith(
        targetReservedNodeCount.map(value => value: java.lang.Integer)
      )(_.targetReservedNodeCount)
      .optionallyWith(
        targetReservedNodeOffering.map(value => value.buildAwsValue())
      )(_.targetReservedNodeOffering)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly =
    zio.aws.redshift.model.ReservedNodeConfigurationOption.wrap(buildAwsValue())
}
object ReservedNodeConfigurationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeConfigurationOption =
      zio.aws.redshift.model.ReservedNodeConfigurationOption(
        sourceReservedNode.map(value => value.asEditable),
        targetReservedNodeCount.map(value => value),
        targetReservedNodeOffering.map(value => value.asEditable)
      )
    def sourceReservedNode
        : Optional[zio.aws.redshift.model.ReservedNode.ReadOnly]
    def targetReservedNodeCount: Optional[Integer]
    def targetReservedNodeOffering
        : Optional[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly]
    def getSourceReservedNode
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly] =
      AwsError.unwrapOptionField("sourceReservedNode", sourceReservedNode)
    def getTargetReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("targetReservedNodeCount", targetReservedNodeCount)
    def getTargetReservedNodeOffering: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetReservedNodeOffering",
      targetReservedNodeOffering
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ) extends zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly {
    override val sourceReservedNode
        : Optional[zio.aws.redshift.model.ReservedNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceReservedNode())
        .map(value => zio.aws.redshift.model.ReservedNode.wrap(value))
    override val targetReservedNodeCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeCount())
        .map(value => value: Integer)
    override val targetReservedNodeOffering
        : Optional[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeOffering())
        .map(value => zio.aws.redshift.model.ReservedNodeOffering.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption
  ): zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly =
    new Wrapper(impl)
}
