package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDefaultClusterParametersRequest(
    parameterGroupFamily: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest = {
    import DescribeDefaultClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest
      .builder()
      .parameterGroupFamily(parameterGroupFamily: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDefaultClusterParametersRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDefaultClusterParametersRequest
      .wrap(buildAwsValue())
}
object DescribeDefaultClusterParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDefaultClusterParametersRequest =
      zio.aws.redshift.model.DescribeDefaultClusterParametersRequest(
        parameterGroupFamily,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def parameterGroupFamily: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupFamily)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest
  ) extends zio.aws.redshift.model.DescribeDefaultClusterParametersRequest.ReadOnly {
    override val parameterGroupFamily: String =
      impl.parameterGroupFamily(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest
  ): zio.aws.redshift.model.DescribeDefaultClusterParametersRequest.ReadOnly =
    new Wrapper(impl)
}
