package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{LongOptional, DoubleOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataTransferProgress(
    status: Optional[String] = Optional.Absent,
    currentRateInMegaBytesPerSecond: Optional[DoubleOptional] = Optional.Absent,
    totalDataInMegaBytes: Optional[Long] = Optional.Absent,
    dataTransferredInMegaBytes: Optional[Long] = Optional.Absent,
    estimatedTimeToCompletionInSeconds: Optional[LongOptional] =
      Optional.Absent,
    elapsedTimeInSeconds: Optional[LongOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DataTransferProgress = {
    import DataTransferProgress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DataTransferProgress
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        currentRateInMegaBytesPerSecond.map(value => value: java.lang.Double)
      )(_.currentRateInMegaBytesPerSecond)
      .optionallyWith(totalDataInMegaBytes.map(value => value: java.lang.Long))(
        _.totalDataInMegaBytes
      )
      .optionallyWith(
        dataTransferredInMegaBytes.map(value => value: java.lang.Long)
      )(_.dataTransferredInMegaBytes)
      .optionallyWith(
        estimatedTimeToCompletionInSeconds.map(value => value: java.lang.Long)
      )(_.estimatedTimeToCompletionInSeconds)
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DataTransferProgress.ReadOnly =
    zio.aws.redshift.model.DataTransferProgress.wrap(buildAwsValue())
}
object DataTransferProgress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DataTransferProgress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DataTransferProgress =
      zio.aws.redshift.model.DataTransferProgress(
        status.map(value => value),
        currentRateInMegaBytesPerSecond.map(value => value),
        totalDataInMegaBytes.map(value => value),
        dataTransferredInMegaBytes.map(value => value),
        estimatedTimeToCompletionInSeconds.map(value => value),
        elapsedTimeInSeconds.map(value => value)
      )
    def status: Optional[String]
    def currentRateInMegaBytesPerSecond: Optional[DoubleOptional]
    def totalDataInMegaBytes: Optional[Long]
    def dataTransferredInMegaBytes: Optional[Long]
    def estimatedTimeToCompletionInSeconds: Optional[LongOptional]
    def elapsedTimeInSeconds: Optional[LongOptional]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCurrentRateInMegaBytesPerSecond: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField(
        "currentRateInMegaBytesPerSecond",
        currentRateInMegaBytesPerSecond
      )
    def getTotalDataInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalDataInMegaBytes", totalDataInMegaBytes)
    def getDataTransferredInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "dataTransferredInMegaBytes",
        dataTransferredInMegaBytes
      )
    def getEstimatedTimeToCompletionInSeconds
        : ZIO[Any, AwsError, LongOptional] = AwsError.unwrapOptionField(
      "estimatedTimeToCompletionInSeconds",
      estimatedTimeToCompletionInSeconds
    )
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DataTransferProgress
  ) extends zio.aws.redshift.model.DataTransferProgress.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val currentRateInMegaBytesPerSecond: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentRateInMegaBytesPerSecond())
        .map(value => value: DoubleOptional)
    override val totalDataInMegaBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalDataInMegaBytes())
      .map(value => value: Long)
    override val dataTransferredInMegaBytes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTransferredInMegaBytes())
        .map(value => value: Long)
    override val estimatedTimeToCompletionInSeconds: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeToCompletionInSeconds())
        .map(value => value: LongOptional)
    override val elapsedTimeInSeconds: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elapsedTimeInSeconds())
        .map(value => value: LongOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DataTransferProgress
  ): zio.aws.redshift.model.DataTransferProgress.ReadOnly = new Wrapper(impl)
}
