package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHsmConfigurationResponse(
    hsmConfiguration: Optional[zio.aws.redshift.model.HsmConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse = {
    import CreateHsmConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse
      .builder()
      .optionallyWith(hsmConfiguration.map(value => value.buildAwsValue()))(
        _.hsmConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly =
    zio.aws.redshift.model.CreateHsmConfigurationResponse.wrap(buildAwsValue())
}
object CreateHsmConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateHsmConfigurationResponse =
      zio.aws.redshift.model.CreateHsmConfigurationResponse(
        hsmConfiguration.map(value => value.asEditable)
      )
    def hsmConfiguration
        : Optional[zio.aws.redshift.model.HsmConfiguration.ReadOnly]
    def getHsmConfiguration
        : ZIO[Any, AwsError, zio.aws.redshift.model.HsmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("hsmConfiguration", hsmConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse
  ) extends zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly {
    override val hsmConfiguration
        : Optional[zio.aws.redshift.model.HsmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmConfiguration())
        .map(value => zio.aws.redshift.model.HsmConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse
  ): zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
