package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHsmClientCertificateResponse(
    hsmClientCertificate: Optional[
      zio.aws.redshift.model.HsmClientCertificate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse = {
    import CreateHsmClientCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse
      .builder()
      .optionallyWith(hsmClientCertificate.map(value => value.buildAwsValue()))(
        _.hsmClientCertificate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly =
    zio.aws.redshift.model.CreateHsmClientCertificateResponse
      .wrap(buildAwsValue())
}
object CreateHsmClientCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateHsmClientCertificateResponse =
      zio.aws.redshift.model.CreateHsmClientCertificateResponse(
        hsmClientCertificate.map(value => value.asEditable)
      )
    def hsmClientCertificate
        : Optional[zio.aws.redshift.model.HsmClientCertificate.ReadOnly]
    def getHsmClientCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.HsmClientCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("hsmClientCertificate", hsmClientCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse
  ) extends zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly {
    override val hsmClientCertificate
        : Optional[zio.aws.redshift.model.HsmClientCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificate())
        .map(value => zio.aws.redshift.model.HsmClientCertificate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse
  ): zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
