package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.LongOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyUsageLimitRequest(
    usageLimitId: String,
    amount: Optional[LongOptional] = Optional.Absent,
    breachAction: Optional[zio.aws.redshift.model.UsageLimitBreachAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest = {
    import ModifyUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
      .builder()
      .usageLimitId(usageLimitId: java.lang.String)
      .optionallyWith(amount.map(value => value: java.lang.Long))(_.amount)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly =
    zio.aws.redshift.model.ModifyUsageLimitRequest.wrap(buildAwsValue())
}
object ModifyUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyUsageLimitRequest =
      zio.aws.redshift.model.ModifyUsageLimitRequest(
        usageLimitId,
        amount.map(value => value),
        breachAction.map(value => value)
      )
    def usageLimitId: String
    def amount: Optional[LongOptional]
    def breachAction: Optional[zio.aws.redshift.model.UsageLimitBreachAction]
    def getUsageLimitId: ZIO[Any, Nothing, String] = ZIO.succeed(usageLimitId)
    def getAmount: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("amount", amount)
    def getBreachAction
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitBreachAction] =
      AwsError.unwrapOptionField("breachAction", breachAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ) extends zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly {
    override val usageLimitId: String = impl.usageLimitId(): String
    override val amount: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: LongOptional)
    override val breachAction
        : Optional[zio.aws.redshift.model.UsageLimitBreachAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.breachAction())
        .map(value => zio.aws.redshift.model.UsageLimitBreachAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest
  ): zio.aws.redshift.model.ModifyUsageLimitRequest.ReadOnly = new Wrapper(impl)
}
