package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointAccessResponse(
    clusterIdentifier: Optional[String] = Optional.Absent,
    resourceOwner: Optional[String] = Optional.Absent,
    subnetGroupName: Optional[String] = Optional.Absent,
    endpointStatus: Optional[String] = Optional.Absent,
    endpointName: Optional[String] = Optional.Absent,
    endpointCreateTime: Optional[TStamp] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    address: Optional[String] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.redshift.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    vpcEndpoint: Optional[zio.aws.redshift.model.VpcEndpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse = {
    import DeleteEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(endpointStatus.map(value => value: java.lang.String))(
        _.endpointStatus
      )
      .optionallyWith(endpointName.map(value => value: java.lang.String))(
        _.endpointName
      )
      .optionallyWith(
        endpointCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.endpointCreateTime)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly =
    zio.aws.redshift.model.DeleteEndpointAccessResponse.wrap(buildAwsValue())
}
object DeleteEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteEndpointAccessResponse =
      zio.aws.redshift.model.DeleteEndpointAccessResponse(
        clusterIdentifier.map(value => value),
        resourceOwner.map(value => value),
        subnetGroupName.map(value => value),
        endpointStatus.map(value => value),
        endpointName.map(value => value),
        endpointCreateTime.map(value => value),
        port.map(value => value),
        address.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpoint.map(value => value.asEditable)
      )
    def clusterIdentifier: Optional[String]
    def resourceOwner: Optional[String]
    def subnetGroupName: Optional[String]
    def endpointStatus: Optional[String]
    def endpointName: Optional[String]
    def endpointCreateTime: Optional[TStamp]
    def port: Optional[Integer]
    def address: Optional[String]
    def vpcSecurityGroups: Optional[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def vpcEndpoint: Optional[zio.aws.redshift.model.VpcEndpoint.ReadOnly]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupName)
    def getEndpointStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getEndpointCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endpointCreateTime", endpointCreateTime)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.redshift.model.VpcEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse
  ) extends zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val resourceOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwner())
      .map(value => value: String)
    override val subnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupName())
      .map(value => value: String)
    override val endpointStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointStatus())
      .map(value => value: String)
    override val endpointName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => value: String)
    override val endpointCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: String)
    override val vpcSecurityGroups: Optional[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcEndpoint
        : Optional[zio.aws.redshift.model.VpcEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpoint())
        .map(value => zio.aws.redshift.model.VpcEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse
  ): zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
