package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteClusterSnapshotResponse(
    snapshot: Optional[zio.aws.redshift.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse = {
    import DeleteClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.DeleteClusterSnapshotResponse.wrap(buildAwsValue())
}
object DeleteClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterSnapshotResponse =
      zio.aws.redshift.model
        .DeleteClusterSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse
  ) extends zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.redshift.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse
  ): zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
