package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDefaultClusterParametersResponse(
    defaultClusterParameters: Optional[
      zio.aws.redshift.model.DefaultClusterParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse = {
    import DescribeDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse
      .builder()
      .optionallyWith(
        defaultClusterParameters.map(value => value.buildAwsValue())
      )(_.defaultClusterParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly =
    zio.aws.redshift.model.DescribeDefaultClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeDefaultClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDefaultClusterParametersResponse =
      zio.aws.redshift.model.DescribeDefaultClusterParametersResponse(
        defaultClusterParameters.map(value => value.asEditable)
      )
    def defaultClusterParameters
        : Optional[zio.aws.redshift.model.DefaultClusterParameters.ReadOnly]
    def getDefaultClusterParameters: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DefaultClusterParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultClusterParameters",
      defaultClusterParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse
  ) extends zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly {
    override val defaultClusterParameters
        : Optional[zio.aws.redshift.model.DefaultClusterParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultClusterParameters())
        .map(value =>
          zio.aws.redshift.model.DefaultClusterParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse
  ): zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
