package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyClusterSubnetGroupResponse(
    clusterSubnetGroup: Optional[zio.aws.redshift.model.ClusterSubnetGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse = {
    import ModifyClusterSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse
      .builder()
      .optionallyWith(clusterSubnetGroup.map(value => value.buildAwsValue()))(
        _.clusterSubnetGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSubnetGroupResponse
      .wrap(buildAwsValue())
}
object ModifyClusterSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterSubnetGroupResponse =
      zio.aws.redshift.model.ModifyClusterSubnetGroupResponse(
        clusterSubnetGroup.map(value => value.asEditable)
      )
    def clusterSubnetGroup
        : Optional[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly]
    def getClusterSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSubnetGroup", clusterSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse
  ) extends zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly {
    override val clusterSubnetGroup
        : Optional[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroup())
        .map(value => zio.aws.redshift.model.ClusterSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse
  ): zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
