package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeClusterDbRevisionsRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest = {
    import DescribeClusterDbRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterDbRevisionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterDbRevisionsRequest
      .wrap(buildAwsValue())
}
object DescribeClusterDbRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterDbRevisionsRequest =
      zio.aws.redshift.model.DescribeClusterDbRevisionsRequest(
        clusterIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest
  ) extends zio.aws.redshift.model.DescribeClusterDbRevisionsRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest
  ): zio.aws.redshift.model.DescribeClusterDbRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
