package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class ScheduledAction(
    scheduledActionName: Optional[String] = Optional.Absent,
    targetAction: Optional[zio.aws.redshift.model.ScheduledActionType] =
      Optional.Absent,
    schedule: Optional[String] = Optional.Absent,
    iamRole: Optional[String] = Optional.Absent,
    scheduledActionDescription: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.redshift.model.ScheduledActionState] =
      Optional.Absent,
    nextInvocations: Optional[Iterable[TStamp]] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ScheduledAction = {
    import ScheduledAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ScheduledAction
      .builder()
      .optionallyWith(
        scheduledActionName.map(value => value: java.lang.String)
      )(_.scheduledActionName)
      .optionallyWith(targetAction.map(value => value.buildAwsValue()))(
        _.targetAction
      )
      .optionallyWith(schedule.map(value => value: java.lang.String))(
        _.schedule
      )
      .optionallyWith(iamRole.map(value => value: java.lang.String))(_.iamRole)
      .optionallyWith(
        scheduledActionDescription.map(value => value: java.lang.String)
      )(_.scheduledActionDescription)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        nextInvocations.map(value =>
          value.map { item =>
            TStamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.nextInvocations)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ScheduledAction.ReadOnly =
    zio.aws.redshift.model.ScheduledAction.wrap(buildAwsValue())
}
object ScheduledAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ScheduledAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ScheduledAction =
      zio.aws.redshift.model.ScheduledAction(
        scheduledActionName.map(value => value),
        targetAction.map(value => value.asEditable),
        schedule.map(value => value),
        iamRole.map(value => value),
        scheduledActionDescription.map(value => value),
        state.map(value => value),
        nextInvocations.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def scheduledActionName: Optional[String]
    def targetAction
        : Optional[zio.aws.redshift.model.ScheduledActionType.ReadOnly]
    def schedule: Optional[String]
    def iamRole: Optional[String]
    def scheduledActionDescription: Optional[String]
    def state: Optional[zio.aws.redshift.model.ScheduledActionState]
    def nextInvocations: Optional[List[TStamp]]
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def getScheduledActionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledActionName", scheduledActionName)
    def getTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ScheduledActionType.ReadOnly
    ] = AwsError.unwrapOptionField("targetAction", targetAction)
    def getSchedule: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getIamRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getScheduledActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "scheduledActionDescription",
        scheduledActionDescription
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduledActionState] =
      AwsError.unwrapOptionField("state", state)
    def getNextInvocations: ZIO[Any, AwsError, List[TStamp]] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledAction
  ) extends zio.aws.redshift.model.ScheduledAction.ReadOnly {
    override val scheduledActionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledActionName())
      .map(value => value: String)
    override val targetAction
        : Optional[zio.aws.redshift.model.ScheduledActionType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetAction())
        .map(value => zio.aws.redshift.model.ScheduledActionType.wrap(value))
    override val schedule: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value => value: String)
    override val iamRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => value: String)
    override val scheduledActionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledActionDescription())
        .map(value => value: String)
    override val state: Optional[zio.aws.redshift.model.ScheduledActionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.redshift.model.ScheduledActionState.wrap(value))
    override val nextInvocations: Optional[List[TStamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.nextInvocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.primitives.TStamp(item)
        }.toList
      )
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledAction
  ): zio.aws.redshift.model.ScheduledAction.ReadOnly = new Wrapper(impl)
}
