package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesRequest(
    dataShareArn: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest = {
    import DescribeDataSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest
      .builder()
      .optionallyWith(dataShareArn.map(value => value: java.lang.String))(
        _.dataShareArn
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeDataSharesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesRequest.wrap(buildAwsValue())
}
object DescribeDataSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeDataSharesRequest =
      zio.aws.redshift.model.DescribeDataSharesRequest(
        dataShareArn.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dataShareArn: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getDataShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataShareArn", dataShareArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest
  ) extends zio.aws.redshift.model.DescribeDataSharesRequest.ReadOnly {
    override val dataShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataShareArn())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest
  ): zio.aws.redshift.model.DescribeDataSharesRequest.ReadOnly = new Wrapper(
    impl
  )
}
