package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class DataShareAssociation(
    consumerIdentifier: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.DataShareStatus] = Optional.Absent,
    consumerRegion: Optional[String] = Optional.Absent,
    createdDate: Optional[TStamp] = Optional.Absent,
    statusChangeDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DataShareAssociation = {
    import DataShareAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DataShareAssociation
      .builder()
      .optionallyWith(consumerIdentifier.map(value => value: java.lang.String))(
        _.consumerIdentifier
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(consumerRegion.map(value => value: java.lang.String))(
        _.consumerRegion
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        statusChangeDate.map(value => TStamp.unwrap(value): Instant)
      )(_.statusChangeDate)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DataShareAssociation.ReadOnly =
    zio.aws.redshift.model.DataShareAssociation.wrap(buildAwsValue())
}
object DataShareAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DataShareAssociation =
      zio.aws.redshift.model.DataShareAssociation(
        consumerIdentifier.map(value => value),
        status.map(value => value),
        consumerRegion.map(value => value),
        createdDate.map(value => value),
        statusChangeDate.map(value => value)
      )
    def consumerIdentifier: Optional[String]
    def status: Optional[zio.aws.redshift.model.DataShareStatus]
    def consumerRegion: Optional[String]
    def createdDate: Optional[TStamp]
    def statusChangeDate: Optional[TStamp]
    def getConsumerIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerIdentifier", consumerIdentifier)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshift.model.DataShareStatus] =
      AwsError.unwrapOptionField("status", status)
    def getConsumerRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerRegion", consumerRegion)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getStatusChangeDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("statusChangeDate", statusChangeDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ) extends zio.aws.redshift.model.DataShareAssociation.ReadOnly {
    override val consumerIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerIdentifier())
      .map(value => value: String)
    override val status: Optional[zio.aws.redshift.model.DataShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshift.model.DataShareStatus.wrap(value))
    override val consumerRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerRegion())
      .map(value => value: String)
    override val createdDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val statusChangeDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.statusChangeDate())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DataShareAssociation
  ): zio.aws.redshift.model.DataShareAssociation.ReadOnly = new Wrapper(impl)
}
