package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttributeValueTarget(
    attributeValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AttributeValueTarget = {
    import AttributeValueTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AttributeValueTarget
      .builder()
      .optionallyWith(attributeValue.map(value => value: java.lang.String))(
        _.attributeValue
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AttributeValueTarget.ReadOnly =
    zio.aws.redshift.model.AttributeValueTarget.wrap(buildAwsValue())
}
object AttributeValueTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AttributeValueTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AttributeValueTarget =
      zio.aws.redshift.model
        .AttributeValueTarget(attributeValue.map(value => value))
    def attributeValue: Optional[String]
    def getAttributeValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AttributeValueTarget
  ) extends zio.aws.redshift.model.AttributeValueTarget.ReadOnly {
    override val attributeValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AttributeValueTarget
  ): zio.aws.redshift.model.AttributeValueTarget.ReadOnly = new Wrapper(impl)
}
