package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterSecurityGroup(
    clusterSecurityGroupName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    ec2SecurityGroups: Optional[
      Iterable[zio.aws.redshift.model.EC2SecurityGroup]
    ] = Optional.Absent,
    ipRanges: Optional[Iterable[zio.aws.redshift.model.IPRange]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup = {
    import ClusterSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup
      .builder()
      .optionallyWith(
        clusterSecurityGroupName.map(value => value: java.lang.String)
      )(_.clusterSecurityGroupName)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2SecurityGroups)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly =
    zio.aws.redshift.model.ClusterSecurityGroup.wrap(buildAwsValue())
}
object ClusterSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterSecurityGroup =
      zio.aws.redshift.model.ClusterSecurityGroup(
        clusterSecurityGroupName.map(value => value),
        description.map(value => value),
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterSecurityGroupName: Optional[String]
    def description: Optional[String]
    def ec2SecurityGroups
        : Optional[List[zio.aws.redshift.model.EC2SecurityGroup.ReadOnly]]
    def ipRanges: Optional[List[zio.aws.redshift.model.IPRange.ReadOnly]]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSecurityGroupName", clusterSecurityGroupName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EC2SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroups)
    def getIpRanges
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.IPRange.ReadOnly]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup
  ) extends zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly {
    override val clusterSecurityGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroupName())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val ec2SecurityGroups
        : Optional[List[zio.aws.redshift.model.EC2SecurityGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.EC2SecurityGroup.wrap(item)
          }.toList
        )
    override val ipRanges
        : Optional[List[zio.aws.redshift.model.IPRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.IPRange.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup
  ): zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly = new Wrapper(impl)
}
