package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScheduledActionFilter(
    name: zio.aws.redshift.model.ScheduledActionFilterName,
    values: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ScheduledActionFilter = {
    import ScheduledActionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ScheduledActionFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ScheduledActionFilter.ReadOnly =
    zio.aws.redshift.model.ScheduledActionFilter.wrap(buildAwsValue())
}
object ScheduledActionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ScheduledActionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ScheduledActionFilter =
      zio.aws.redshift.model.ScheduledActionFilter(name, values)
    def name: zio.aws.redshift.model.ScheduledActionFilterName
    def values: List[String]
    def getName
        : ZIO[Any, Nothing, zio.aws.redshift.model.ScheduledActionFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionFilter
  ) extends zio.aws.redshift.model.ScheduledActionFilter.ReadOnly {
    override val name: zio.aws.redshift.model.ScheduledActionFilterName =
      zio.aws.redshift.model.ScheduledActionFilterName.wrap(impl.name())
    override val values: List[String] = impl
      .values()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionFilter
  ): zio.aws.redshift.model.ScheduledActionFilter.ReadOnly = new Wrapper(impl)
}
