package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName,
  PartnerIntegrationClusterIdentifier,
  PartnerIntegrationAccountId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePartnerRequest(
    accountId: PartnerIntegrationAccountId,
    clusterIdentifier: PartnerIntegrationClusterIdentifier,
    databaseName: PartnerIntegrationDatabaseName,
    partnerName: PartnerIntegrationPartnerName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeletePartnerRequest = {
    import DeletePartnerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeletePartnerRequest
      .builder()
      .accountId(
        PartnerIntegrationAccountId.unwrap(accountId): java.lang.String
      )
      .clusterIdentifier(
        PartnerIntegrationClusterIdentifier.unwrap(
          clusterIdentifier
        ): java.lang.String
      )
      .databaseName(
        PartnerIntegrationDatabaseName.unwrap(databaseName): java.lang.String
      )
      .partnerName(
        PartnerIntegrationPartnerName.unwrap(partnerName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeletePartnerRequest.ReadOnly =
    zio.aws.redshift.model.DeletePartnerRequest.wrap(buildAwsValue())
}
object DeletePartnerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeletePartnerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeletePartnerRequest =
      zio.aws.redshift.model.DeletePartnerRequest(
        accountId,
        clusterIdentifier,
        databaseName,
        partnerName
      )
    def accountId: PartnerIntegrationAccountId
    def clusterIdentifier: PartnerIntegrationClusterIdentifier
    def databaseName: PartnerIntegrationDatabaseName
    def partnerName: PartnerIntegrationPartnerName
    def getAccountId: ZIO[Any, Nothing, PartnerIntegrationAccountId] =
      ZIO.succeed(accountId)
    def getClusterIdentifier
        : ZIO[Any, Nothing, PartnerIntegrationClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getDatabaseName: ZIO[Any, Nothing, PartnerIntegrationDatabaseName] =
      ZIO.succeed(databaseName)
    def getPartnerName: ZIO[Any, Nothing, PartnerIntegrationPartnerName] =
      ZIO.succeed(partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerRequest
  ) extends zio.aws.redshift.model.DeletePartnerRequest.ReadOnly {
    override val accountId: PartnerIntegrationAccountId =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationAccountId(impl.accountId())
    override val clusterIdentifier: PartnerIntegrationClusterIdentifier =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationClusterIdentifier(impl.clusterIdentifier())
    override val databaseName: PartnerIntegrationDatabaseName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationDatabaseName(impl.databaseName())
    override val partnerName: PartnerIntegrationPartnerName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationPartnerName(impl.partnerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeletePartnerRequest
  ): zio.aws.redshift.model.DeletePartnerRequest.ReadOnly = new Wrapper(impl)
}
