package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyClusterSnapshotResponse(
    snapshot: Optional[zio.aws.redshift.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse = {
    import CopyClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.CopyClusterSnapshotResponse.wrap(buildAwsValue())
}
object CopyClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CopyClusterSnapshotResponse =
      zio.aws.redshift.model
        .CopyClusterSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.redshift.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse
  ) extends zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.redshift.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshift.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse
  ): zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
