package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RevokeSnapshotAccessRequest(
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Optional[String] = Optional.Absent,
    accountWithRestoreAccess: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest = {
    import RevokeSnapshotAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .accountWithRestoreAccess(accountWithRestoreAccess: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly =
    zio.aws.redshift.model.RevokeSnapshotAccessRequest.wrap(buildAwsValue())
}
object RevokeSnapshotAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeSnapshotAccessRequest =
      zio.aws.redshift.model.RevokeSnapshotAccessRequest(
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value),
        accountWithRestoreAccess
      )
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Optional[String]
    def accountWithRestoreAccess: String
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getAccountWithRestoreAccess: ZIO[Any, Nothing, String] =
      ZIO.succeed(accountWithRestoreAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ) extends zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotClusterIdentifier())
        .map(value => value: String)
    override val accountWithRestoreAccess: String =
      impl.accountWithRestoreAccess(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ): zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
