package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class RevokeEndpointAccessResponse(
    grantor: Optional[String] = Optional.Absent,
    grantee: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    authorizeTime: Optional[TStamp] = Optional.Absent,
    clusterStatus: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.AuthorizationStatus] =
      Optional.Absent,
    allowedAllVPCs: Optional[Boolean] = Optional.Absent,
    allowedVPCs: Optional[Iterable[String]] = Optional.Absent,
    endpointCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse = {
    import RevokeEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse
      .builder()
      .optionallyWith(grantor.map(value => value: java.lang.String))(_.grantor)
      .optionallyWith(grantee.map(value => value: java.lang.String))(_.grantee)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        authorizeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.authorizeTime)
      .optionallyWith(clusterStatus.map(value => value: java.lang.String))(
        _.clusterStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(allowedAllVPCs.map(value => value: java.lang.Boolean))(
        _.allowedAllVPCs
      )
      .optionallyWith(
        allowedVPCs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedVPCs)
      .optionallyWith(endpointCount.map(value => value: java.lang.Integer))(
        _.endpointCount
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly =
    zio.aws.redshift.model.RevokeEndpointAccessResponse.wrap(buildAwsValue())
}
object RevokeEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeEndpointAccessResponse =
      zio.aws.redshift.model.RevokeEndpointAccessResponse(
        grantor.map(value => value),
        grantee.map(value => value),
        clusterIdentifier.map(value => value),
        authorizeTime.map(value => value),
        clusterStatus.map(value => value),
        status.map(value => value),
        allowedAllVPCs.map(value => value),
        allowedVPCs.map(value => value),
        endpointCount.map(value => value)
      )
    def grantor: Optional[String]
    def grantee: Optional[String]
    def clusterIdentifier: Optional[String]
    def authorizeTime: Optional[TStamp]
    def clusterStatus: Optional[String]
    def status: Optional[zio.aws.redshift.model.AuthorizationStatus]
    def allowedAllVPCs: Optional[Boolean]
    def allowedVPCs: Optional[List[String]]
    def endpointCount: Optional[Integer]
    def getGrantor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("grantor", grantor)
    def getGrantee: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAuthorizeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("authorizeTime", authorizeTime)
    def getClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AuthorizationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAllowedAllVPCs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowedAllVPCs", allowedAllVPCs)
    def getAllowedVPCs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("allowedVPCs", allowedVPCs)
    def getEndpointCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endpointCount", endpointCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse
  ) extends zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly {
    override val grantor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.grantor())
      .map(value => value: String)
    override val grantee: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.grantee())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val authorizeTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizeTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val clusterStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterStatus())
      .map(value => value: String)
    override val status: Optional[zio.aws.redshift.model.AuthorizationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshift.model.AuthorizationStatus.wrap(value))
    override val allowedAllVPCs: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedAllVPCs())
      .map(value => value: Boolean)
    override val allowedVPCs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedVPCs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val endpointCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse
  ): zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
