package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReservedNodeOffering(
    reservedNodeOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.redshift.model.RecurringCharge]
    ] = Optional.Absent,
    reservedNodeOfferingType: Optional[
      zio.aws.redshift.model.ReservedNodeOfferingType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeOffering = {
    import ReservedNodeOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
      .builder()
      .optionallyWith(
        reservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodeOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(reservedNodeOfferingType.map(value => value.unwrap))(
        _.reservedNodeOfferingType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ReservedNodeOffering.ReadOnly =
    zio.aws.redshift.model.ReservedNodeOffering.wrap(buildAwsValue())
}
object ReservedNodeOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeOffering =
      zio.aws.redshift.model.ReservedNodeOffering(
        reservedNodeOfferingId.map(value => value),
        nodeType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedNodeOfferingType.map(value => value)
      )
    def reservedNodeOfferingId: Optional[String]
    def nodeType: Optional[String]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def offeringType: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]]
    def reservedNodeOfferingType
        : Optional[zio.aws.redshift.model.ReservedNodeOfferingType]
    def getReservedNodeOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodeOfferingId", reservedNodeOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservedNodeOfferingType
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNodeOfferingType] =
      AwsError.unwrapOptionField(
        "reservedNodeOfferingType",
        reservedNodeOfferingType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ) extends zio.aws.redshift.model.ReservedNodeOffering.ReadOnly {
    override val reservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val reservedNodeOfferingType
        : Optional[zio.aws.redshift.model.ReservedNodeOfferingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeOfferingType())
        .map(value =>
          zio.aws.redshift.model.ReservedNodeOfferingType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeOffering
  ): zio.aws.redshift.model.ReservedNodeOffering.ReadOnly = new Wrapper(impl)
}
