package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifySnapshotScheduleResponse(
    scheduleDefinitions: Optional[Iterable[String]] = Optional.Absent,
    scheduleIdentifier: Optional[String] = Optional.Absent,
    scheduleDescription: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent,
    nextInvocations: Optional[Iterable[TStamp]] = Optional.Absent,
    associatedClusterCount: Optional[IntegerOptional] = Optional.Absent,
    associatedClusters: Optional[
      Iterable[zio.aws.redshift.model.ClusterAssociatedToSchedule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse = {
    import ModifySnapshotScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse
      .builder()
      .optionallyWith(
        scheduleDefinitions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scheduleDefinitions)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        scheduleDescription.map(value => value: java.lang.String)
      )(_.scheduleDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextInvocations.map(value =>
          value.map { item =>
            TStamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.nextInvocations)
      .optionallyWith(associatedClusterCount.map(value => value: Integer))(
        _.associatedClusterCount
      )
      .optionallyWith(
        associatedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedClusters)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly =
    zio.aws.redshift.model.ModifySnapshotScheduleResponse.wrap(buildAwsValue())
}
object ModifySnapshotScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifySnapshotScheduleResponse =
      zio.aws.redshift.model.ModifySnapshotScheduleResponse(
        scheduleDefinitions.map(value => value),
        scheduleIdentifier.map(value => value),
        scheduleDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextInvocations.map(value => value),
        associatedClusterCount.map(value => value),
        associatedClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scheduleDefinitions: Optional[List[String]]
    def scheduleIdentifier: Optional[String]
    def scheduleDescription: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def nextInvocations: Optional[List[TStamp]]
    def associatedClusterCount: Optional[IntegerOptional]
    def associatedClusters: Optional[
      List[zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly]
    ]
    def getScheduleDefinitions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scheduleDefinitions", scheduleDefinitions)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getScheduleDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleDescription", scheduleDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextInvocations: ZIO[Any, AwsError, List[TStamp]] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
    def getAssociatedClusterCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "associatedClusterCount",
        associatedClusterCount
      )
    def getAssociatedClusters: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedClusters", associatedClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse
  ) extends zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly {
    override val scheduleDefinitions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleDefinitions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val scheduleIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleIdentifier())
      .map(value => value: String)
    override val scheduleDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleDescription())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
    override val nextInvocations: Optional[List[TStamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.nextInvocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.primitives.TStamp(item)
        }.toList
      )
    override val associatedClusterCount: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedClusterCount())
        .map(value => value: IntegerOptional)
    override val associatedClusters: Optional[
      List[zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associatedClusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterAssociatedToSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse
  ): zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
