package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeStorageResponse(
    totalBackupSizeInMegaBytes: Optional[Double] = Optional.Absent,
    totalProvisionedStorageInMegaBytes: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeStorageResponse = {
    import DescribeStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
      .builder()
      .optionallyWith(
        totalBackupSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalBackupSizeInMegaBytes)
      .optionallyWith(
        totalProvisionedStorageInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalProvisionedStorageInMegaBytes)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeStorageResponse.ReadOnly =
    zio.aws.redshift.model.DescribeStorageResponse.wrap(buildAwsValue())
}
object DescribeStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeStorageResponse =
      zio.aws.redshift.model.DescribeStorageResponse(
        totalBackupSizeInMegaBytes.map(value => value),
        totalProvisionedStorageInMegaBytes.map(value => value)
      )
    def totalBackupSizeInMegaBytes: Optional[Double]
    def totalProvisionedStorageInMegaBytes: Optional[Double]
    def getTotalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalBackupSizeInMegaBytes",
        totalBackupSizeInMegaBytes
      )
    def getTotalProvisionedStorageInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalProvisionedStorageInMegaBytes",
        totalProvisionedStorageInMegaBytes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ) extends zio.aws.redshift.model.DescribeStorageResponse.ReadOnly {
    override val totalBackupSizeInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalBackupSizeInMegaBytes())
        .map(value => value: Double)
    override val totalProvisionedStorageInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalProvisionedStorageInMegaBytes())
        .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeStorageResponse
  ): zio.aws.redshift.model.DescribeStorageResponse.ReadOnly = new Wrapper(impl)
}
