package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAttributesRequest(
    attributeNames: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest = {
    import DescribeAccountAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
      .builder()
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeNames)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeAccountAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeAccountAttributesRequest =
      zio.aws.redshift.model
        .DescribeAccountAttributesRequest(attributeNames.map(value => value))
    def attributeNames: Optional[List[String]]
    def getAttributeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ) extends zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly {
    override val attributeNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest
  ): zio.aws.redshift.model.DescribeAccountAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
