package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTagsRequest(
    resourceName: String,
    tags: Iterable[zio.aws.redshift.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateTagsRequest = {
    import CreateTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateTagsRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateTagsRequest.ReadOnly =
    zio.aws.redshift.model.CreateTagsRequest.wrap(buildAwsValue())
}
object CreateTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateTagsRequest =
      zio.aws.redshift.model.CreateTagsRequest(
        resourceName,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceName: String
    def tags: List[zio.aws.redshift.model.Tag.ReadOnly]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateTagsRequest
  ) extends zio.aws.redshift.model.CreateTagsRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tags: List[zio.aws.redshift.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.redshift.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateTagsRequest
  ): zio.aws.redshift.model.CreateTagsRequest.ReadOnly = new Wrapper(impl)
}
