package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait PartnerIntegrationStatus {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus
}
object PartnerIntegrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus
  ): zio.aws.redshift.model.PartnerIntegrationStatus = value match {
    case software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.INACTIVE =>
      val r = Inactive
      r
    case software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.RUNTIME_FAILURE =>
      val r = RuntimeFailure
      r
    case software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.CONNECTION_FAILURE =>
      val r = ConnectionFailure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.PartnerIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.redshift.model.PartnerIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.ACTIVE
  }
  case object Inactive extends zio.aws.redshift.model.PartnerIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.INACTIVE
  }
  case object RuntimeFailure
      extends zio.aws.redshift.model.PartnerIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.RUNTIME_FAILURE
  }
  case object ConnectionFailure
      extends zio.aws.redshift.model.PartnerIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.PartnerIntegrationStatus.CONNECTION_FAILURE
  }
}
