package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifySnapshotCopyRetentionPeriodRequest(
    clusterIdentifier: String,
    retentionPeriod: Integer,
    manual: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest = {
    import ModifySnapshotCopyRetentionPeriodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .retentionPeriod(retentionPeriod: java.lang.Integer)
      .optionallyWith(manual.map(value => value: java.lang.Boolean))(_.manual)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest.ReadOnly =
    zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
      .wrap(buildAwsValue())
}
object ModifySnapshotCopyRetentionPeriodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest =
      zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest(
        clusterIdentifier,
        retentionPeriod,
        manual.map(value => value)
      )
    def clusterIdentifier: String
    def retentionPeriod: Integer
    def manual: Optional[Boolean]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getRetentionPeriod: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(retentionPeriod)
    def getManual: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("manual", manual)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
  ) extends zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val retentionPeriod: Integer = impl.retentionPeriod(): Integer
    override val manual: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.manual())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
  ): zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodRequest.ReadOnly =
    new Wrapper(impl)
}
