package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointAccessResponse(
    endpointAccessList: Optional[
      Iterable[zio.aws.redshift.model.EndpointAccess]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse = {
    import DescribeEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse
      .builder()
      .optionallyWith(
        endpointAccessList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointAccessList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAccessResponse.wrap(buildAwsValue())
}
object DescribeEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEndpointAccessResponse =
      zio.aws.redshift.model.DescribeEndpointAccessResponse(
        endpointAccessList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def endpointAccessList
        : Optional[List[zio.aws.redshift.model.EndpointAccess.ReadOnly]]
    def marker: Optional[String]
    def getEndpointAccessList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EndpointAccess.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointAccessList", endpointAccessList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse
  ) extends zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly {
    override val endpointAccessList
        : Optional[List[zio.aws.redshift.model.EndpointAccess.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointAccessList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.EndpointAccess.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse
  ): zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
