package zio.aws.redshift
import zio.aws.redshift.model.DescribeDataSharesForProducerResponse.ReadOnly
import zio.aws.redshift.model.{
  DescribeEventCategoriesRequest,
  DescribeHsmConfigurationsRequest,
  DescribeLoggingStatusRequest,
  DescribeSnapshotSchedulesRequest,
  DescribeClusterSubnetGroupsRequest,
  DescribeSnapshotCopyGrantsRequest,
  AuthorizeSnapshotAccessRequest,
  ModifySnapshotScheduleRequest,
  ResizeClusterRequest,
  DescribeReservedNodesRequest,
  DescribeEndpointAuthorizationRequest,
  AuthorizeEndpointAccessRequest,
  ModifyEventSubscriptionRequest,
  ResetClusterParameterGroupRequest,
  AuthorizeDataShareRequest,
  DeauthorizeDataShareRequest,
  DescribeScheduledActionsRequest,
  GetReservedNodeExchangeConfigurationOptionsRequest,
  DisableSnapshotCopyRequest,
  CancelResizeRequest,
  DeleteTagsRequest,
  DescribePartnersRequest,
  CreateEventSubscriptionRequest,
  DescribeClusterSecurityGroupsRequest,
  RevokeSnapshotAccessRequest,
  EnableSnapshotCopyRequest,
  DescribeAuthenticationProfilesRequest,
  DescribeClusterParametersRequest,
  AuthorizeClusterSecurityGroupIngressRequest,
  DeleteSnapshotCopyGrantRequest,
  DeleteClusterSubnetGroupRequest,
  DescribeClusterSnapshotsRequest,
  DescribeOrderableClusterOptionsRequest,
  DescribeHsmClientCertificatesRequest,
  CreateClusterSubnetGroupRequest,
  ModifyClusterParameterGroupRequest,
  DescribeEventsRequest,
  DescribeDataSharesForConsumerRequest,
  ModifySnapshotCopyRetentionPeriodRequest,
  CreateTagsRequest,
  DisassociateDataShareConsumerRequest,
  DescribeReservedNodeExchangeStatusRequest,
  DeleteEventSubscriptionRequest,
  DescribeEndpointAccessRequest,
  RebootClusterRequest,
  DescribeNodeConfigurationOptionsRequest,
  BatchDeleteClusterSnapshotsRequest,
  RejectDataShareRequest,
  CreateClusterSecurityGroupRequest,
  RotateEncryptionKeyRequest,
  CreateClusterRequest,
  DeletePartnerRequest,
  DescribeUsageLimitsRequest,
  ModifyAuthenticationProfileRequest,
  ModifyClusterDbRevisionRequest,
  DescribeDataSharesRequest,
  DescribeDefaultClusterParametersRequest,
  DeleteUsageLimitRequest,
  DescribeClusterVersionsRequest,
  RevokeEndpointAccessRequest,
  DeleteAuthenticationProfileRequest,
  GetReservedNodeExchangeOfferingsRequest,
  RevokeClusterSecurityGroupIngressRequest,
  DeleteClusterRequest,
  DeleteHsmClientCertificateRequest,
  CreateUsageLimitRequest,
  DeleteClusterSnapshotRequest,
  AcceptReservedNodeExchangeRequest,
  DescribeClusterParameterGroupsRequest,
  DescribeClusterTracksRequest,
  ResumeClusterRequest,
  DeleteScheduledActionRequest,
  CreateHsmConfigurationRequest,
  ModifyAquaConfigurationRequest,
  ModifyUsageLimitRequest,
  CreateClusterSnapshotRequest,
  CreateClusterParameterGroupRequest,
  CreateHsmClientCertificateRequest,
  DeleteClusterSecurityGroupRequest,
  RestoreFromClusterSnapshotRequest,
  DescribeTagsRequest,
  DescribeDataSharesForProducerRequest,
  CreateScheduledActionRequest,
  AssociateDataShareConsumerRequest,
  ModifyClusterSnapshotRequest,
  PauseClusterRequest,
  ModifyClusterSnapshotScheduleRequest,
  DescribeTableRestoreStatusRequest,
  BatchModifyClusterSnapshotsRequest,
  AddPartnerRequest,
  CreateSnapshotScheduleRequest,
  DescribeAccountAttributesRequest,
  ModifyEndpointAccessRequest,
  DescribeReservedNodeOfferingsRequest,
  CopyClusterSnapshotRequest,
  DescribeResizeRequest,
  DeleteClusterParameterGroupRequest,
  DeleteHsmConfigurationRequest,
  ModifyClusterRequest,
  ModifyScheduledActionRequest,
  ModifyClusterSubnetGroupRequest,
  DisableLoggingRequest,
  CreateEndpointAccessRequest,
  RestoreTableFromClusterSnapshotRequest,
  ModifyClusterIamRolesRequest,
  DescribeEventSubscriptionsRequest,
  DeleteSnapshotScheduleRequest,
  PurchaseReservedNodeOfferingRequest,
  DescribeClusterDbRevisionsRequest,
  DescribeClustersRequest,
  CreateAuthenticationProfileRequest,
  UpdatePartnerStatusRequest,
  GetClusterCredentialsRequest,
  EnableLoggingRequest,
  DeleteEndpointAccessRequest,
  ModifyClusterMaintenanceRequest,
  CreateSnapshotCopyGrantRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.redshift.{
  RedshiftAsyncClientBuilder,
  RedshiftAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.redshift.model.{
  CreateClusterSecurityGroupResponse,
  CreateEndpointAccessResponse,
  CreateClusterSubnetGroupResponse,
  DescribeHsmConfigurationsResponse,
  ResetClusterParameterGroupResponse,
  DescribeEventsResponse,
  CreateUsageLimitResponse,
  EventSubscription,
  DescribeEndpointAuthorizationResponse,
  ModifyClusterSnapshotResponse,
  ResizeClusterResponse,
  RotateEncryptionKeyResponse,
  AuthorizeSnapshotAccessResponse,
  DisassociateDataShareConsumerResponse,
  DescribeLoggingStatusResponse,
  NodeConfigurationOption,
  RebootClusterResponse,
  Cluster,
  TableRestoreStatus,
  UpdatePartnerStatusResponse,
  ModifyClusterSubnetGroupResponse,
  DescribeSnapshotCopyGrantsResponse,
  DeauthorizeDataShareResponse,
  AuthorizeEndpointAccessResponse,
  ModifyUsageLimitResponse,
  PurchaseReservedNodeOfferingResponse,
  DescribeClusterTracksResponse,
  DescribeClusterSecurityGroupsResponse,
  DescribeClusterSnapshotsResponse,
  DescribeEventCategoriesResponse,
  RevokeSnapshotAccessResponse,
  DeleteTagsResponse,
  DescribeClusterParametersResponse,
  ModifyClusterParameterGroupResponse,
  ModifyAuthenticationProfileResponse,
  ModifyEventSubscriptionResponse,
  DescribeClusterSubnetGroupsResponse,
  GetReservedNodeExchangeConfigurationOptionsResponse,
  OrderableClusterOption,
  DescribeClusterVersionsResponse,
  ModifyAquaConfigurationResponse,
  SnapshotSchedule,
  DescribeScheduledActionsResponse,
  CreateAuthenticationProfileResponse,
  DescribeReservedNodeOfferingsResponse,
  AssociateDataShareConsumerResponse,
  TaggedResource,
  HsmClientCertificate,
  DeleteClusterSubnetGroupResponse,
  DisableLoggingResponse,
  ClusterDbRevision,
  ModifySnapshotScheduleResponse,
  DescribeStorageRequest,
  DeleteUsageLimitResponse,
  DescribePartnersResponse,
  UsageLimit,
  DescribeClusterParameterGroupsResponse,
  CreateScheduledActionResponse,
  CreateHsmClientCertificateResponse,
  ReservedNodeExchangeStatus,
  DeleteScheduledActionResponse,
  DescribeNodeConfigurationOptionsResponse,
  CreateHsmConfigurationResponse,
  CopyClusterSnapshotResponse,
  Snapshot,
  DescribeSnapshotSchedulesResponse,
  DescribeAuthenticationProfilesResponse,
  DataShare,
  GetClusterCredentialsResponse,
  DescribeStorageResponse,
  DescribeEventSubscriptionsResponse,
  DescribeClusterDbRevisionsResponse,
  AuthorizeDataShareResponse,
  HsmConfiguration,
  ModifySnapshotCopyRetentionPeriodResponse,
  CreateClusterResponse,
  DeleteSnapshotCopyGrantResponse,
  CreateEventSubscriptionResponse,
  ReservedNodeOffering,
  BatchDeleteClusterSnapshotsResponse,
  EndpointAccess,
  DescribeHsmClientCertificatesResponse,
  PauseClusterResponse,
  ReservedNode,
  ReservedNodeConfigurationOption,
  DescribeEndpointAccessResponse,
  ModifyClusterDbRevisionResponse,
  ClusterSubnetGroup,
  ClusterParameterGroup,
  DeleteHsmClientCertificateResponse,
  RestoreFromClusterSnapshotResponse,
  ClusterVersion,
  DescribeClustersResponse,
  DisableSnapshotCopyResponse,
  AddPartnerResponse,
  RevokeEndpointAccessResponse,
  DescribeDataSharesForProducerResponse,
  DeleteAuthenticationProfileResponse,
  CreateSnapshotScheduleResponse,
  DeleteClusterParameterGroupResponse,
  ScheduledAction,
  EnableSnapshotCopyResponse,
  RestoreTableFromClusterSnapshotResponse,
  CancelResizeResponse,
  AcceptReservedNodeExchangeResponse,
  ResumeClusterResponse,
  ModifyClusterMaintenanceResponse,
  EnableLoggingResponse,
  DeletePartnerResponse,
  RejectDataShareResponse,
  SnapshotCopyGrant,
  ModifyEndpointAccessResponse,
  CreateClusterSnapshotResponse,
  DescribeUsageLimitsResponse,
  Event,
  EndpointAuthorization,
  DeleteClusterSnapshotResponse,
  DescribeDataSharesResponse,
  ModifyClusterSnapshotScheduleResponse,
  DeleteClusterResponse,
  CreateClusterParameterGroupResponse,
  ModifyClusterIamRolesResponse,
  ClusterSecurityGroup,
  GetReservedNodeExchangeOfferingsResponse,
  MaintenanceTrack,
  DescribeOrderableClusterOptionsResponse,
  AuthorizeClusterSecurityGroupIngressResponse,
  DeleteEndpointAccessResponse,
  DescribeDataSharesForConsumerResponse,
  CreateSnapshotCopyGrantResponse,
  DescribeTagsResponse,
  DescribeDefaultClusterParametersResponse,
  RevokeClusterSecurityGroupIngressResponse,
  DeleteSnapshotScheduleResponse,
  DescribeReservedNodeExchangeStatusResponse,
  DescribeReservedNodesResponse,
  Parameter,
  DeleteEventSubscriptionResponse,
  DeleteHsmConfigurationResponse,
  DescribeAccountAttributesResponse,
  DescribeResizeResponse,
  ModifyScheduledActionResponse,
  ModifyClusterResponse,
  DeleteClusterSecurityGroupResponse,
  CreateTagsResponse,
  DescribeTableRestoreStatusResponse,
  BatchModifyClusterSnapshotsResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.redshift.paginators.{
  DescribeHsmConfigurationsPublisher,
  DescribeClusterDbRevisionsPublisher,
  DescribeClusterParameterGroupsPublisher,
  DescribeClustersPublisher,
  GetReservedNodeExchangeOfferingsPublisher,
  DescribeClusterSnapshotsPublisher,
  DescribeEndpointAccessPublisher,
  DescribeEventSubscriptionsPublisher,
  DescribeSnapshotCopyGrantsPublisher,
  DescribeTableRestoreStatusPublisher,
  DescribeTagsPublisher,
  DescribeSnapshotSchedulesPublisher,
  DescribeHsmClientCertificatesPublisher,
  DescribeClusterSubnetGroupsPublisher,
  DescribeReservedNodeOfferingsPublisher,
  DescribeNodeConfigurationOptionsPublisher,
  DescribeScheduledActionsPublisher,
  DescribeEndpointAuthorizationPublisher,
  DescribeReservedNodesPublisher,
  DescribeDataSharesForConsumerPublisher,
  DescribeClusterVersionsPublisher,
  DescribeClusterParametersPublisher,
  DescribeUsageLimitsPublisher,
  DescribeReservedNodeExchangeStatusPublisher,
  DescribeOrderableClusterOptionsPublisher,
  DescribeClusterTracksPublisher,
  DescribeDataSharesPublisher,
  GetReservedNodeExchangeConfigurationOptionsPublisher,
  DescribeClusterSecurityGroupsPublisher,
  DescribeEventsPublisher,
  DescribeDataSharesForProducerPublisher
}
import scala.jdk.CollectionConverters.*
trait Redshift extends AspectSupport[Redshift] {
  val api: RedshiftAsyncClient
  def deleteHsmConfiguration(
      request: DeleteHsmConfigurationRequest
  ): IO[AwsError, Unit]
  def authorizeSnapshotAccess(request: AuthorizeSnapshotAccessRequest): IO[
    AwsError,
    zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly
  ]
  def describeTags(
      request: DescribeTagsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.TaggedResource.ReadOnly]
  def describeTagsPaginated(
      request: DescribeTagsRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeTagsResponse.ReadOnly]
  def modifyClusterSubnetGroup(request: ModifyClusterSubnetGroupRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly
  ]
  def resetClusterParameterGroup(
      request: ResetClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly
  ]
  def deleteClusterParameterGroup(
      request: DeleteClusterParameterGroupRequest
  ): IO[AwsError, Unit]
  def resumeCluster(
      request: ResumeClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.ResumeClusterResponse.ReadOnly]
  def describeClusters(
      request: DescribeClustersRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly]
  def describeClustersPaginated(
      request: DescribeClustersRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeClustersResponse.ReadOnly]
  def modifyUsageLimit(
      request: ModifyUsageLimitRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyUsageLimitResponse.ReadOnly]
  def describeClusterDbRevisions(
      request: DescribeClusterDbRevisionsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.ClusterDbRevision.ReadOnly]
  def describeClusterDbRevisionsPaginated(
      request: DescribeClusterDbRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly
  ]
  def acceptReservedNodeExchange(
      request: AcceptReservedNodeExchangeRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly
  ]
  def modifyScheduledAction(
      request: ModifyScheduledActionRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyScheduledActionResponse.ReadOnly]
  def getReservedNodeExchangeConfigurationOptions(
      request: GetReservedNodeExchangeConfigurationOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
  ]
  def getReservedNodeExchangeConfigurationOptionsPaginated(
      request: GetReservedNodeExchangeConfigurationOptionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly
  ]
  def describeDefaultClusterParameters(
      request: DescribeDefaultClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly
  ]
  def modifyEndpointAccess(
      request: ModifyEndpointAccessRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyEndpointAccessResponse.ReadOnly]
  def createClusterSecurityGroup(
      request: CreateClusterSecurityGroupRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly
  ]
  def batchDeleteClusterSnapshots(
      request: BatchDeleteClusterSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly
  ]
  def createAuthenticationProfile(
      request: CreateAuthenticationProfileRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly
  ]
  def deleteHsmClientCertificate(
      request: DeleteHsmClientCertificateRequest
  ): IO[AwsError, Unit]
  def describeClusterParameterGroups(
      request: DescribeClusterParameterGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
  ]
  def describeClusterParameterGroupsPaginated(
      request: DescribeClusterParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly
  ]
  def describeReservedNodes(
      request: DescribeReservedNodesRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly]
  def describeReservedNodesPaginated(
      request: DescribeReservedNodesRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly]
  def disableSnapshotCopy(
      request: DisableSnapshotCopyRequest
  ): IO[AwsError, zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly]
  def enableSnapshotCopy(
      request: EnableSnapshotCopyRequest
  ): IO[AwsError, zio.aws.redshift.model.EnableSnapshotCopyResponse.ReadOnly]
  def describeClusterVersions(
      request: DescribeClusterVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.ClusterVersion.ReadOnly]
  def describeClusterVersionsPaginated(
      request: DescribeClusterVersionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly
  ]
  def modifyClusterSnapshotSchedule(
      request: ModifyClusterSnapshotScheduleRequest
  ): IO[AwsError, Unit]
  def deleteSnapshotCopyGrant(
      request: DeleteSnapshotCopyGrantRequest
  ): IO[AwsError, Unit]
  def modifyAquaConfiguration(request: ModifyAquaConfigurationRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly
  ]
  def describeClusterTracks(
      request: DescribeClusterTracksRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.MaintenanceTrack.ReadOnly]
  def describeClusterTracksPaginated(
      request: DescribeClusterTracksRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly]
  def createHsmConfiguration(request: CreateHsmConfigurationRequest): IO[
    AwsError,
    zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly
  ]
  def describeDataSharesForConsumer(
      request: DescribeDataSharesForConsumerRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly]
  def describeDataSharesForConsumerPaginated(
      request: DescribeDataSharesForConsumerRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly
  ]
  def deleteEventSubscription(
      request: DeleteEventSubscriptionRequest
  ): IO[AwsError, Unit]
  def modifyClusterSnapshot(
      request: ModifyClusterSnapshotRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly]
  def restoreTableFromClusterSnapshot(
      request: RestoreTableFromClusterSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly
  ]
  def describeUsageLimits(
      request: DescribeUsageLimitsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.UsageLimit.ReadOnly]
  def describeUsageLimitsPaginated(
      request: DescribeUsageLimitsRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly]
  def describeResize(
      request: DescribeResizeRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeResizeResponse.ReadOnly]
  def deleteSnapshotSchedule(
      request: DeleteSnapshotScheduleRequest
  ): IO[AwsError, Unit]
  def createCluster(
      request: CreateClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.CreateClusterResponse.ReadOnly]
  def associateDataShareConsumer(
      request: AssociateDataShareConsumerRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.AssociateDataShareConsumerResponse.ReadOnly
  ]
  def deleteClusterSnapshot(
      request: DeleteClusterSnapshotRequest
  ): IO[AwsError, zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly]
  def deleteCluster(
      request: DeleteClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.DeleteClusterResponse.ReadOnly]
  def deleteUsageLimit(request: DeleteUsageLimitRequest): IO[AwsError, Unit]
  def cancelResize(
      request: CancelResizeRequest
  ): IO[AwsError, zio.aws.redshift.model.CancelResizeResponse.ReadOnly]
  def pauseCluster(
      request: PauseClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.PauseClusterResponse.ReadOnly]
  def deleteEndpointAccess(
      request: DeleteEndpointAccessRequest
  ): IO[AwsError, zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly]
  def resizeCluster(
      request: ResizeClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.ResizeClusterResponse.ReadOnly]
  def describeClusterSecurityGroups(
      request: DescribeClusterSecurityGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
  ]
  def describeClusterSecurityGroupsPaginated(
      request: DescribeClusterSecurityGroupsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly
  ]
  def createSnapshotCopyGrant(request: CreateSnapshotCopyGrantRequest): IO[
    AwsError,
    zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly
  ]
  def describeHsmConfigurations(
      request: DescribeHsmConfigurationsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.HsmConfiguration.ReadOnly]
  def describeHsmConfigurationsPaginated(
      request: DescribeHsmConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly
  ]
  def describeClusterParameters(
      request: DescribeClusterParametersRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.Parameter.ReadOnly]
  def describeClusterParametersPaginated(
      request: DescribeClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly
  ]
  def createEndpointAccess(
      request: CreateEndpointAccessRequest
  ): IO[AwsError, zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly]
  def addPartner(
      request: AddPartnerRequest
  ): IO[AwsError, zio.aws.redshift.model.AddPartnerResponse.ReadOnly]
  def describeOrderableClusterOptions(
      request: DescribeOrderableClusterOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.OrderableClusterOption.ReadOnly
  ]
  def describeOrderableClusterOptionsPaginated(
      request: DescribeOrderableClusterOptionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly
  ]
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly
  ]
  def describeLoggingStatus(
      request: DescribeLoggingStatusRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeLoggingStatusResponse.ReadOnly]
  def createHsmClientCertificate(
      request: CreateHsmClientCertificateRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly
  ]
  def deletePartner(
      request: DeletePartnerRequest
  ): IO[AwsError, zio.aws.redshift.model.DeletePartnerResponse.ReadOnly]
  def describeNodeConfigurationOptions(
      request: DescribeNodeConfigurationOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
  ]
  def describeNodeConfigurationOptionsPaginated(
      request: DescribeNodeConfigurationOptionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly
  ]
  def describeTableRestoreStatus(
      request: DescribeTableRestoreStatusRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.TableRestoreStatus.ReadOnly]
  def describeTableRestoreStatusPaginated(
      request: DescribeTableRestoreStatusRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly
  ]
  def rebootCluster(
      request: RebootClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.RebootClusterResponse.ReadOnly]
  def enableLogging(
      request: EnableLoggingRequest
  ): IO[AwsError, zio.aws.redshift.model.EnableLoggingResponse.ReadOnly]
  def revokeEndpointAccess(
      request: RevokeEndpointAccessRequest
  ): IO[AwsError, zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly]
  def describeAuthenticationProfiles(
      request: DescribeAuthenticationProfilesRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly
  ]
  def createScheduledAction(
      request: CreateScheduledActionRequest
  ): IO[AwsError, zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly]
  def deleteClusterSecurityGroup(
      request: DeleteClusterSecurityGroupRequest
  ): IO[AwsError, Unit]
  def describePartners(
      request: DescribePartnersRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribePartnersResponse.ReadOnly]
  def describeHsmClientCertificates(
      request: DescribeHsmClientCertificatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.HsmClientCertificate.ReadOnly
  ]
  def describeHsmClientCertificatesPaginated(
      request: DescribeHsmClientCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly
  ]
  def describeEventCategories(request: DescribeEventCategoriesRequest): IO[
    AwsError,
    zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly
  ]
  def modifyClusterDbRevision(request: ModifyClusterDbRevisionRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly
  ]
  def createSnapshotSchedule(request: CreateSnapshotScheduleRequest): IO[
    AwsError,
    zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly
  ]
  def describeDataShares(
      request: DescribeDataSharesRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly]
  def describeDataSharesPaginated(
      request: DescribeDataSharesRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly]
  def describeClusterSnapshots(
      request: DescribeClusterSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly]
  def describeClusterSnapshotsPaginated(
      request: DescribeClusterSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly
  ]
  def getReservedNodeExchangeOfferings(
      request: GetReservedNodeExchangeOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
  ]
  def getReservedNodeExchangeOfferingsPaginated(
      request: GetReservedNodeExchangeOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.ReadOnly
  ]
  def describeStorage()
      : IO[AwsError, zio.aws.redshift.model.DescribeStorageResponse.ReadOnly]
  def modifyCluster(
      request: ModifyClusterRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyClusterResponse.ReadOnly]
  def authorizeDataShare(
      request: AuthorizeDataShareRequest
  ): IO[AwsError, zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly]
  def describeReservedNodeExchangeStatus(
      request: DescribeReservedNodeExchangeStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
  ]
  def describeReservedNodeExchangeStatusPaginated(
      request: DescribeReservedNodeExchangeStatusRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly
  ]
  def modifyClusterParameterGroup(
      request: ModifyClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly
  ]
  def revokeSnapshotAccess(
      request: RevokeSnapshotAccessRequest
  ): IO[AwsError, zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly]
  def createEventSubscription(request: CreateEventSubscriptionRequest): IO[
    AwsError,
    zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly
  ]
  def modifyClusterMaintenance(request: ModifyClusterMaintenanceRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly
  ]
  def createUsageLimit(
      request: CreateUsageLimitRequest
  ): IO[AwsError, zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly]
  def modifySnapshotCopyRetentionPeriod(
      request: ModifySnapshotCopyRetentionPeriodRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.ReadOnly
  ]
  def deauthorizeDataShare(
      request: DeauthorizeDataShareRequest
  ): IO[AwsError, zio.aws.redshift.model.DeauthorizeDataShareResponse.ReadOnly]
  def rotateEncryptionKey(
      request: RotateEncryptionKeyRequest
  ): IO[AwsError, zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly]
  def describeEndpointAuthorization(
      request: DescribeEndpointAuthorizationRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.EndpointAuthorization.ReadOnly
  ]
  def describeEndpointAuthorizationPaginated(
      request: DescribeEndpointAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly
  ]
  def describeScheduledActions(
      request: DescribeScheduledActionsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.ScheduledAction.ReadOnly]
  def describeScheduledActionsPaginated(
      request: DescribeScheduledActionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly
  ]
  def modifyClusterIamRoles(
      request: ModifyClusterIamRolesRequest
  ): IO[AwsError, zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly]
  def deleteScheduledAction(
      request: DeleteScheduledActionRequest
  ): IO[AwsError, Unit]
  def getClusterCredentials(
      request: GetClusterCredentialsRequest
  ): IO[AwsError, zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly]
  def rejectDataShare(
      request: RejectDataShareRequest
  ): IO[AwsError, zio.aws.redshift.model.RejectDataShareResponse.ReadOnly]
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.EventSubscription.ReadOnly]
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeEventSubscriptionsResponse.ReadOnly
  ]
  def deleteAuthenticationProfile(
      request: DeleteAuthenticationProfileRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly
  ]
  def createClusterParameterGroup(
      request: CreateClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly
  ]
  def createClusterSnapshot(
      request: CreateClusterSnapshotRequest
  ): IO[AwsError, zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly]
  def describeSnapshotSchedules(
      request: DescribeSnapshotSchedulesRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.SnapshotSchedule.ReadOnly]
  def describeSnapshotSchedulesPaginated(
      request: DescribeSnapshotSchedulesRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly
  ]
  def describeClusterSubnetGroups(
      request: DescribeClusterSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly]
  def describeClusterSubnetGroupsPaginated(
      request: DescribeClusterSubnetGroupsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly
  ]
  def createClusterSubnetGroup(request: CreateClusterSubnetGroupRequest): IO[
    AwsError,
    zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly
  ]
  def modifyAuthenticationProfile(
      request: ModifyAuthenticationProfileRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly
  ]
  def describeDataSharesForProducer(
      request: DescribeDataSharesForProducerRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly]
  def describeDataSharesForProducerPaginated(
      request: DescribeDataSharesForProducerRequest
  ): IO[AwsError, ReadOnly]
  def describeReservedNodeOfferings(
      request: DescribeReservedNodeOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
  ]
  def describeReservedNodeOfferingsPaginated(
      request: DescribeReservedNodeOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly
  ]
  def modifySnapshotSchedule(request: ModifySnapshotScheduleRequest): IO[
    AwsError,
    zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly
  ]
  def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit]
  def purchaseReservedNodeOffering(
      request: PurchaseReservedNodeOfferingRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly
  ]
  def describeAccountAttributes(request: DescribeAccountAttributesRequest): IO[
    AwsError,
    zio.aws.redshift.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def batchModifyClusterSnapshots(
      request: BatchModifyClusterSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly
  ]
  def deleteClusterSubnetGroup(
      request: DeleteClusterSubnetGroupRequest
  ): IO[AwsError, Unit]
  def revokeClusterSecurityGroupIngress(
      request: RevokeClusterSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly
  ]
  def authorizeClusterSecurityGroupIngress(
      request: AuthorizeClusterSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly
  ]
  def updatePartnerStatus(
      request: UpdatePartnerStatusRequest
  ): IO[AwsError, zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly]
  def copyClusterSnapshot(
      request: CopyClusterSnapshotRequest
  ): IO[AwsError, zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly]
  def describeSnapshotCopyGrants(
      request: DescribeSnapshotCopyGrantsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly]
  def describeSnapshotCopyGrantsPaginated(
      request: DescribeSnapshotCopyGrantsRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly
  ]
  def authorizeEndpointAccess(request: AuthorizeEndpointAccessRequest): IO[
    AwsError,
    zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly
  ]
  def restoreFromClusterSnapshot(
      request: RestoreFromClusterSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly
  ]
  def disableLogging(
      request: DisableLoggingRequest
  ): IO[AwsError, zio.aws.redshift.model.DisableLoggingResponse.ReadOnly]
  def disassociateDataShareConsumer(
      request: DisassociateDataShareConsumerRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DisassociateDataShareConsumerResponse.ReadOnly
  ]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.redshift.model.DescribeEventsResponse.ReadOnly]
  def describeEndpointAccess(
      request: DescribeEndpointAccessRequest
  ): ZStream[Any, AwsError, zio.aws.redshift.model.EndpointAccess.ReadOnly]
  def describeEndpointAccessPaginated(
      request: DescribeEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly
  ]
  def createTags(request: CreateTagsRequest): IO[AwsError, Unit]
}
object Redshift {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Redshift] = customized(
    identity
  )
  def customized(
      customization: RedshiftAsyncClientBuilder => RedshiftAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Redshift] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RedshiftAsyncClientBuilder => RedshiftAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Redshift] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RedshiftAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RedshiftAsyncClient, RedshiftAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[RedshiftAsyncClient, RedshiftAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RedshiftImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RedshiftImpl[R](
      override val api: RedshiftAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Redshift
      with AwsServiceBase[R] {
    override val serviceName: String = "Redshift"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RedshiftImpl[R1] = new RedshiftImpl(api, newAspect, r)
    def deleteHsmConfiguration(
        request: DeleteHsmConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest,
      DeleteHsmConfigurationResponse
    ]("deleteHsmConfiguration", api.deleteHsmConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def authorizeSnapshotAccess(request: AuthorizeSnapshotAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest,
      AuthorizeSnapshotAccessResponse
    ]("authorizeSnapshotAccess", api.authorizeSnapshotAccess)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.wrap)
      .provideEnvironment(r)
    def describeTags(
        request: DescribeTagsRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.TaggedResource.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeTagsRequest,
        TaggedResource,
        DescribeTagsPublisher
      ]("describeTags", api.describeTagsPaginator, _.taggedResources())(
        request.buildAwsValue()
      ).map(item => zio.aws.redshift.model.TaggedResource.wrap(item))
        .provideEnvironment(r)
    def describeTagsPaginated(
        request: DescribeTagsRequest
    ): IO[AwsError, zio.aws.redshift.model.DescribeTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DescribeTagsRequest,
        DescribeTagsResponse
      ]("describeTags", api.describeTags)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DescribeTagsResponse.wrap)
        .provideEnvironment(r)
    def modifyClusterSubnetGroup(request: ModifyClusterSubnetGroupRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest,
      ModifyClusterSubnetGroupResponse
    ]("modifyClusterSubnetGroup", api.modifyClusterSubnetGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def resetClusterParameterGroup(
        request: ResetClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest,
      ResetClusterParameterGroupResponse
    ]("resetClusterParameterGroup", api.resetClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ResetClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteClusterParameterGroup(
        request: DeleteClusterParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest,
      DeleteClusterParameterGroupResponse
    ]("deleteClusterParameterGroup", api.deleteClusterParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resumeCluster(
        request: ResumeClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.ResumeClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.ResumeClusterRequest,
        ResumeClusterResponse
      ]("resumeCluster", api.resumeCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.ResumeClusterResponse.wrap)
        .provideEnvironment(r)
    def describeClusters(
        request: DescribeClustersRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeClustersRequest,
        Cluster,
        DescribeClustersPublisher
      ]("describeClusters", api.describeClustersPaginator, _.clusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.redshift.model.Cluster.wrap(item))
        .provideEnvironment(r)
    def describeClustersPaginated(
        request: DescribeClustersRequest
    ): IO[AwsError, zio.aws.redshift.model.DescribeClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DescribeClustersRequest,
        DescribeClustersResponse
      ]("describeClusters", api.describeClusters)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DescribeClustersResponse.wrap)
        .provideEnvironment(r)
    def modifyUsageLimit(
        request: ModifyUsageLimitRequest
    ): IO[AwsError, zio.aws.redshift.model.ModifyUsageLimitResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest,
        ModifyUsageLimitResponse
      ]("modifyUsageLimit", api.modifyUsageLimit)(request.buildAwsValue())
        .map(zio.aws.redshift.model.ModifyUsageLimitResponse.wrap)
        .provideEnvironment(r)
    def describeClusterDbRevisions(
        request: DescribeClusterDbRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterDbRevision.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest,
      ClusterDbRevision,
      DescribeClusterDbRevisionsPublisher
    ](
      "describeClusterDbRevisions",
      api.describeClusterDbRevisionsPaginator,
      _.clusterDbRevisions()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ClusterDbRevision.wrap(item))
      .provideEnvironment(r)
    def describeClusterDbRevisionsPaginated(
        request: DescribeClusterDbRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest,
      DescribeClusterDbRevisionsResponse
    ]("describeClusterDbRevisions", api.describeClusterDbRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.wrap)
      .provideEnvironment(r)
    def acceptReservedNodeExchange(
        request: AcceptReservedNodeExchangeRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest,
      AcceptReservedNodeExchangeResponse
    ]("acceptReservedNodeExchange", api.acceptReservedNodeExchange)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.wrap)
      .provideEnvironment(r)
    def modifyScheduledAction(request: ModifyScheduledActionRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyScheduledActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest,
      ModifyScheduledActionResponse
    ]("modifyScheduledAction", api.modifyScheduledAction)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyScheduledActionResponse.wrap)
      .provideEnvironment(r)
    def getReservedNodeExchangeConfigurationOptions(
        request: GetReservedNodeExchangeConfigurationOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest,
      ReservedNodeConfigurationOption,
      GetReservedNodeExchangeConfigurationOptionsPublisher
    ](
      "getReservedNodeExchangeConfigurationOptions",
      api.getReservedNodeExchangeConfigurationOptionsPaginator,
      _.reservedNodeConfigurationOptionList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.redshift.model.ReservedNodeConfigurationOption.wrap(item)
      )
      .provideEnvironment(r)
    def getReservedNodeExchangeConfigurationOptionsPaginated(
        request: GetReservedNodeExchangeConfigurationOptionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest,
      GetReservedNodeExchangeConfigurationOptionsResponse
    ](
      "getReservedNodeExchangeConfigurationOptions",
      api.getReservedNodeExchangeConfigurationOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def describeDefaultClusterParameters(
        request: DescribeDefaultClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest,
      DescribeDefaultClusterParametersResponse
    ]("describeDefaultClusterParameters", api.describeDefaultClusterParameters)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.wrap)
      .provideEnvironment(r)
    def modifyEndpointAccess(request: ModifyEndpointAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest,
      ModifyEndpointAccessResponse
    ]("modifyEndpointAccess", api.modifyEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshift.model.ModifyEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def createClusterSecurityGroup(
        request: CreateClusterSecurityGroupRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest,
      CreateClusterSecurityGroupResponse
    ]("createClusterSecurityGroup", api.createClusterSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateClusterSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteClusterSnapshots(
        request: BatchDeleteClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest,
      BatchDeleteClusterSnapshotsResponse
    ]("batchDeleteClusterSnapshots", api.batchDeleteClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def createAuthenticationProfile(
        request: CreateAuthenticationProfileRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest,
      CreateAuthenticationProfileResponse
    ]("createAuthenticationProfile", api.createAuthenticationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateAuthenticationProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteHsmClientCertificate(
        request: DeleteHsmClientCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest,
      DeleteHsmClientCertificateResponse
    ]("deleteHsmClientCertificate", api.deleteHsmClientCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeClusterParameterGroups(
        request: DescribeClusterParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest,
      ClusterParameterGroup,
      DescribeClusterParameterGroupsPublisher
    ](
      "describeClusterParameterGroups",
      api.describeClusterParameterGroupsPaginator,
      _.parameterGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ClusterParameterGroup.wrap(item))
      .provideEnvironment(r)
    def describeClusterParameterGroupsPaginated(
        request: DescribeClusterParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest,
      DescribeClusterParameterGroupsResponse
    ]("describeClusterParameterGroups", api.describeClusterParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeReservedNodes(
        request: DescribeReservedNodesRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.ReservedNode.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest,
        ReservedNode,
        DescribeReservedNodesPublisher
      ](
        "describeReservedNodes",
        api.describeReservedNodesPaginator,
        _.reservedNodes()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.ReservedNode.wrap(item))
        .provideEnvironment(r)
    def describeReservedNodesPaginated(
        request: DescribeReservedNodesRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest,
      DescribeReservedNodesResponse
    ]("describeReservedNodes", api.describeReservedNodes)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeReservedNodesResponse.wrap)
      .provideEnvironment(r)
    def disableSnapshotCopy(request: DisableSnapshotCopyRequest): IO[
      AwsError,
      zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest,
      DisableSnapshotCopyResponse
    ]("disableSnapshotCopy", api.disableSnapshotCopy)(request.buildAwsValue())
      .map(zio.aws.redshift.model.DisableSnapshotCopyResponse.wrap)
      .provideEnvironment(r)
    def enableSnapshotCopy(request: EnableSnapshotCopyRequest): IO[
      AwsError,
      zio.aws.redshift.model.EnableSnapshotCopyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest,
      EnableSnapshotCopyResponse
    ]("enableSnapshotCopy", api.enableSnapshotCopy)(request.buildAwsValue())
      .map(zio.aws.redshift.model.EnableSnapshotCopyResponse.wrap)
      .provideEnvironment(r)
    def describeClusterVersions(
        request: DescribeClusterVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.ClusterVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest,
        ClusterVersion,
        DescribeClusterVersionsPublisher
      ](
        "describeClusterVersions",
        api.describeClusterVersionsPaginator,
        _.clusterVersions()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.ClusterVersion.wrap(item))
        .provideEnvironment(r)
    def describeClusterVersionsPaginated(
        request: DescribeClusterVersionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest,
      DescribeClusterVersionsResponse
    ]("describeClusterVersions", api.describeClusterVersions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterVersionsResponse.wrap)
      .provideEnvironment(r)
    def modifyClusterSnapshotSchedule(
        request: ModifyClusterSnapshotScheduleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest,
      ModifyClusterSnapshotScheduleResponse
    ]("modifyClusterSnapshotSchedule", api.modifyClusterSnapshotSchedule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteSnapshotCopyGrant(
        request: DeleteSnapshotCopyGrantRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest,
      DeleteSnapshotCopyGrantResponse
    ]("deleteSnapshotCopyGrant", api.deleteSnapshotCopyGrant)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyAquaConfiguration(request: ModifyAquaConfigurationRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest,
      ModifyAquaConfigurationResponse
    ]("modifyAquaConfiguration", api.modifyAquaConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyAquaConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeClusterTracks(request: DescribeClusterTracksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.MaintenanceTrack.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest,
      MaintenanceTrack,
      DescribeClusterTracksPublisher
    ](
      "describeClusterTracks",
      api.describeClusterTracksPaginator,
      _.maintenanceTracks()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.MaintenanceTrack.wrap(item))
      .provideEnvironment(r)
    def describeClusterTracksPaginated(
        request: DescribeClusterTracksRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest,
      DescribeClusterTracksResponse
    ]("describeClusterTracks", api.describeClusterTracks)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterTracksResponse.wrap)
      .provideEnvironment(r)
    def createHsmConfiguration(request: CreateHsmConfigurationRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest,
      CreateHsmConfigurationResponse
    ]("createHsmConfiguration", api.createHsmConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateHsmConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeDataSharesForConsumer(
        request: DescribeDataSharesForConsumerRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest,
        DataShare,
        DescribeDataSharesForConsumerPublisher
      ](
        "describeDataSharesForConsumer",
        api.describeDataSharesForConsumerPaginator,
        _.dataShares()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.DataShare.wrap(item))
        .provideEnvironment(r)
    def describeDataSharesForConsumerPaginated(
        request: DescribeDataSharesForConsumerRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest,
      DescribeDataSharesForConsumerResponse
    ]("describeDataSharesForConsumer", api.describeDataSharesForConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.wrap)
      .provideEnvironment(r)
    def deleteEventSubscription(
        request: DeleteEventSubscriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyClusterSnapshot(request: ModifyClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest,
      ModifyClusterSnapshotResponse
    ]("modifyClusterSnapshot", api.modifyClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def restoreTableFromClusterSnapshot(
        request: RestoreTableFromClusterSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest,
      RestoreTableFromClusterSnapshotResponse
    ]("restoreTableFromClusterSnapshot", api.restoreTableFromClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeUsageLimits(request: DescribeUsageLimitsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.UsageLimit.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest,
      UsageLimit,
      DescribeUsageLimitsPublisher
    ]("describeUsageLimits", api.describeUsageLimitsPaginator, _.usageLimits())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshift.model.UsageLimit.wrap(item))
      .provideEnvironment(r)
    def describeUsageLimitsPaginated(request: DescribeUsageLimitsRequest): IO[
      AwsError,
      zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest,
      DescribeUsageLimitsResponse
    ]("describeUsageLimits", api.describeUsageLimits)(request.buildAwsValue())
      .map(zio.aws.redshift.model.DescribeUsageLimitsResponse.wrap)
      .provideEnvironment(r)
    def describeResize(
        request: DescribeResizeRequest
    ): IO[AwsError, zio.aws.redshift.model.DescribeResizeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DescribeResizeRequest,
        DescribeResizeResponse
      ]("describeResize", api.describeResize)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DescribeResizeResponse.wrap)
        .provideEnvironment(r)
    def deleteSnapshotSchedule(
        request: DeleteSnapshotScheduleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest,
      DeleteSnapshotScheduleResponse
    ]("deleteSnapshotSchedule", api.deleteSnapshotSchedule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createCluster(
        request: CreateClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.CreateClusterRequest,
        CreateClusterResponse
      ]("createCluster", api.createCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def associateDataShareConsumer(
        request: AssociateDataShareConsumerRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.AssociateDataShareConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest,
      AssociateDataShareConsumerResponse
    ]("associateDataShareConsumer", api.associateDataShareConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.AssociateDataShareConsumerResponse.wrap)
      .provideEnvironment(r)
    def deleteClusterSnapshot(request: DeleteClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest,
      DeleteClusterSnapshotResponse
    ]("deleteClusterSnapshot", api.deleteClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DeleteClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteCluster(
        request: DeleteClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DeleteClusterRequest,
        DeleteClusterResponse
      ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteUsageLimit(request: DeleteUsageLimitRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DeleteUsageLimitRequest,
        DeleteUsageLimitResponse
      ]("deleteUsageLimit", api.deleteUsageLimit)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def cancelResize(
        request: CancelResizeRequest
    ): IO[AwsError, zio.aws.redshift.model.CancelResizeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.CancelResizeRequest,
        CancelResizeResponse
      ]("cancelResize", api.cancelResize)(request.buildAwsValue())
        .map(zio.aws.redshift.model.CancelResizeResponse.wrap)
        .provideEnvironment(r)
    def pauseCluster(
        request: PauseClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.PauseClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.PauseClusterRequest,
        PauseClusterResponse
      ]("pauseCluster", api.pauseCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.PauseClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpointAccess(request: DeleteEndpointAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest,
      DeleteEndpointAccessResponse
    ]("deleteEndpointAccess", api.deleteEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshift.model.DeleteEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def resizeCluster(
        request: ResizeClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.ResizeClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.ResizeClusterRequest,
        ResizeClusterResponse
      ]("resizeCluster", api.resizeCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.ResizeClusterResponse.wrap)
        .provideEnvironment(r)
    def describeClusterSecurityGroups(
        request: DescribeClusterSecurityGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest,
      ClusterSecurityGroup,
      DescribeClusterSecurityGroupsPublisher
    ](
      "describeClusterSecurityGroups",
      api.describeClusterSecurityGroupsPaginator,
      _.clusterSecurityGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ClusterSecurityGroup.wrap(item))
      .provideEnvironment(r)
    def describeClusterSecurityGroupsPaginated(
        request: DescribeClusterSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest,
      DescribeClusterSecurityGroupsResponse
    ]("describeClusterSecurityGroups", api.describeClusterSecurityGroups)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def createSnapshotCopyGrant(request: CreateSnapshotCopyGrantRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest,
      CreateSnapshotCopyGrantResponse
    ]("createSnapshotCopyGrant", api.createSnapshotCopyGrant)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.wrap)
      .provideEnvironment(r)
    def describeHsmConfigurations(
        request: DescribeHsmConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.HsmConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest,
      HsmConfiguration,
      DescribeHsmConfigurationsPublisher
    ](
      "describeHsmConfigurations",
      api.describeHsmConfigurationsPaginator,
      _.hsmConfigurations()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.HsmConfiguration.wrap(item))
      .provideEnvironment(r)
    def describeHsmConfigurationsPaginated(
        request: DescribeHsmConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest,
      DescribeHsmConfigurationsResponse
    ]("describeHsmConfigurations", api.describeHsmConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeHsmConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def describeClusterParameters(
        request: DescribeClusterParametersRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest,
        Parameter,
        DescribeClusterParametersPublisher
      ](
        "describeClusterParameters",
        api.describeClusterParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeClusterParametersPaginated(
        request: DescribeClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest,
      DescribeClusterParametersResponse
    ]("describeClusterParameters", api.describeClusterParameters)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterParametersResponse.wrap)
      .provideEnvironment(r)
    def createEndpointAccess(request: CreateEndpointAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest,
      CreateEndpointAccessResponse
    ]("createEndpointAccess", api.createEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshift.model.CreateEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def addPartner(
        request: AddPartnerRequest
    ): IO[AwsError, zio.aws.redshift.model.AddPartnerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.AddPartnerRequest,
        AddPartnerResponse
      ]("addPartner", api.addPartner)(request.buildAwsValue())
        .map(zio.aws.redshift.model.AddPartnerResponse.wrap)
        .provideEnvironment(r)
    def describeOrderableClusterOptions(
        request: DescribeOrderableClusterOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.OrderableClusterOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest,
      OrderableClusterOption,
      DescribeOrderableClusterOptionsPublisher
    ](
      "describeOrderableClusterOptions",
      api.describeOrderableClusterOptionsPaginator,
      _.orderableClusterOptions()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.OrderableClusterOption.wrap(item))
      .provideEnvironment(r)
    def describeOrderableClusterOptionsPaginated(
        request: DescribeOrderableClusterOptionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest,
      DescribeOrderableClusterOptionsResponse
    ]("describeOrderableClusterOptions", api.describeOrderableClusterOptions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.wrap)
      .provideEnvironment(r)
    def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeLoggingStatus(request: DescribeLoggingStatusRequest): IO[
      AwsError,
      zio.aws.redshift.model.DescribeLoggingStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest,
      DescribeLoggingStatusResponse
    ]("describeLoggingStatus", api.describeLoggingStatus)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeLoggingStatusResponse.wrap)
      .provideEnvironment(r)
    def createHsmClientCertificate(
        request: CreateHsmClientCertificateRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest,
      CreateHsmClientCertificateResponse
    ]("createHsmClientCertificate", api.createHsmClientCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateHsmClientCertificateResponse.wrap)
      .provideEnvironment(r)
    def deletePartner(
        request: DeletePartnerRequest
    ): IO[AwsError, zio.aws.redshift.model.DeletePartnerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DeletePartnerRequest,
        DeletePartnerResponse
      ]("deletePartner", api.deletePartner)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DeletePartnerResponse.wrap)
        .provideEnvironment(r)
    def describeNodeConfigurationOptions(
        request: DescribeNodeConfigurationOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest,
      NodeConfigurationOption,
      DescribeNodeConfigurationOptionsPublisher
    ](
      "describeNodeConfigurationOptions",
      api.describeNodeConfigurationOptionsPaginator,
      _.nodeConfigurationOptionList()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.NodeConfigurationOption.wrap(item))
      .provideEnvironment(r)
    def describeNodeConfigurationOptionsPaginated(
        request: DescribeNodeConfigurationOptionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest,
      DescribeNodeConfigurationOptionsResponse
    ]("describeNodeConfigurationOptions", api.describeNodeConfigurationOptions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.wrap)
      .provideEnvironment(r)
    def describeTableRestoreStatus(
        request: DescribeTableRestoreStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.TableRestoreStatus.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest,
      TableRestoreStatus,
      DescribeTableRestoreStatusPublisher
    ](
      "describeTableRestoreStatus",
      api.describeTableRestoreStatusPaginator,
      _.tableRestoreStatusDetails()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.TableRestoreStatus.wrap(item))
      .provideEnvironment(r)
    def describeTableRestoreStatusPaginated(
        request: DescribeTableRestoreStatusRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest,
      DescribeTableRestoreStatusResponse
    ]("describeTableRestoreStatus", api.describeTableRestoreStatus)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeTableRestoreStatusResponse.wrap)
      .provideEnvironment(r)
    def rebootCluster(
        request: RebootClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.RebootClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.RebootClusterRequest,
        RebootClusterResponse
      ]("rebootCluster", api.rebootCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.RebootClusterResponse.wrap)
        .provideEnvironment(r)
    def enableLogging(
        request: EnableLoggingRequest
    ): IO[AwsError, zio.aws.redshift.model.EnableLoggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.EnableLoggingRequest,
        EnableLoggingResponse
      ]("enableLogging", api.enableLogging)(request.buildAwsValue())
        .map(zio.aws.redshift.model.EnableLoggingResponse.wrap)
        .provideEnvironment(r)
    def revokeEndpointAccess(request: RevokeEndpointAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest,
      RevokeEndpointAccessResponse
    ]("revokeEndpointAccess", api.revokeEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshift.model.RevokeEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def describeAuthenticationProfiles(
        request: DescribeAuthenticationProfilesRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest,
      DescribeAuthenticationProfilesResponse
    ]("describeAuthenticationProfiles", api.describeAuthenticationProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.wrap)
      .provideEnvironment(r)
    def createScheduledAction(request: CreateScheduledActionRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest,
      CreateScheduledActionResponse
    ]("createScheduledAction", api.createScheduledAction)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateScheduledActionResponse.wrap)
      .provideEnvironment(r)
    def deleteClusterSecurityGroup(
        request: DeleteClusterSecurityGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest,
      DeleteClusterSecurityGroupResponse
    ]("deleteClusterSecurityGroup", api.deleteClusterSecurityGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describePartners(
        request: DescribePartnersRequest
    ): IO[AwsError, zio.aws.redshift.model.DescribePartnersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DescribePartnersRequest,
        DescribePartnersResponse
      ]("describePartners", api.describePartners)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DescribePartnersResponse.wrap)
        .provideEnvironment(r)
    def describeHsmClientCertificates(
        request: DescribeHsmClientCertificatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.HsmClientCertificate.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest,
      HsmClientCertificate,
      DescribeHsmClientCertificatesPublisher
    ](
      "describeHsmClientCertificates",
      api.describeHsmClientCertificatesPaginator,
      _.hsmClientCertificates()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.HsmClientCertificate.wrap(item))
      .provideEnvironment(r)
    def describeHsmClientCertificatesPaginated(
        request: DescribeHsmClientCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest,
      DescribeHsmClientCertificatesResponse
    ]("describeHsmClientCertificates", api.describeHsmClientCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.wrap)
      .provideEnvironment(r)
    def describeEventCategories(request: DescribeEventCategoriesRequest): IO[
      AwsError,
      zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def modifyClusterDbRevision(request: ModifyClusterDbRevisionRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest,
      ModifyClusterDbRevisionResponse
    ]("modifyClusterDbRevision", api.modifyClusterDbRevision)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterDbRevisionResponse.wrap)
      .provideEnvironment(r)
    def createSnapshotSchedule(request: CreateSnapshotScheduleRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest,
      CreateSnapshotScheduleResponse
    ]("createSnapshotSchedule", api.createSnapshotSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateSnapshotScheduleResponse.wrap)
      .provideEnvironment(r)
    def describeDataShares(request: DescribeDataSharesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.DataShare.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest,
      DataShare,
      DescribeDataSharesPublisher
    ]("describeDataShares", api.describeDataSharesPaginator, _.dataShares())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshift.model.DataShare.wrap(item))
      .provideEnvironment(r)
    def describeDataSharesPaginated(request: DescribeDataSharesRequest): IO[
      AwsError,
      zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest,
      DescribeDataSharesResponse
    ]("describeDataShares", api.describeDataShares)(request.buildAwsValue())
      .map(zio.aws.redshift.model.DescribeDataSharesResponse.wrap)
      .provideEnvironment(r)
    def describeClusterSnapshots(
        request: DescribeClusterSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest,
        Snapshot,
        DescribeClusterSnapshotsPublisher
      ](
        "describeClusterSnapshots",
        api.describeClusterSnapshotsPaginator,
        _.snapshots()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.Snapshot.wrap(item))
        .provideEnvironment(r)
    def describeClusterSnapshotsPaginated(
        request: DescribeClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest,
      DescribeClusterSnapshotsResponse
    ]("describeClusterSnapshots", api.describeClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def getReservedNodeExchangeOfferings(
        request: GetReservedNodeExchangeOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest,
      ReservedNodeOffering,
      GetReservedNodeExchangeOfferingsPublisher
    ](
      "getReservedNodeExchangeOfferings",
      api.getReservedNodeExchangeOfferingsPaginator,
      _.reservedNodeOfferings()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ReservedNodeOffering.wrap(item))
      .provideEnvironment(r)
    def getReservedNodeExchangeOfferingsPaginated(
        request: GetReservedNodeExchangeOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest,
      GetReservedNodeExchangeOfferingsResponse
    ]("getReservedNodeExchangeOfferings", api.getReservedNodeExchangeOfferings)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.wrap)
      .provideEnvironment(r)
    def describeStorage(): IO[
      AwsError,
      zio.aws.redshift.model.DescribeStorageResponse.ReadOnly
    ] = asyncRequestResponse[DescribeStorageRequest, DescribeStorageResponse](
      "describeStorage",
      api.describeStorage
    )(DescribeStorageRequest.builder().build())
      .map(zio.aws.redshift.model.DescribeStorageResponse.wrap)
      .provideEnvironment(r)
    def modifyCluster(
        request: ModifyClusterRequest
    ): IO[AwsError, zio.aws.redshift.model.ModifyClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.ModifyClusterRequest,
        ModifyClusterResponse
      ]("modifyCluster", api.modifyCluster)(request.buildAwsValue())
        .map(zio.aws.redshift.model.ModifyClusterResponse.wrap)
        .provideEnvironment(r)
    def authorizeDataShare(request: AuthorizeDataShareRequest): IO[
      AwsError,
      zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest,
      AuthorizeDataShareResponse
    ]("authorizeDataShare", api.authorizeDataShare)(request.buildAwsValue())
      .map(zio.aws.redshift.model.AuthorizeDataShareResponse.wrap)
      .provideEnvironment(r)
    def describeReservedNodeExchangeStatus(
        request: DescribeReservedNodeExchangeStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest,
      ReservedNodeExchangeStatus,
      DescribeReservedNodeExchangeStatusPublisher
    ](
      "describeReservedNodeExchangeStatus",
      api.describeReservedNodeExchangeStatusPaginator,
      _.reservedNodeExchangeStatusDetails()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(item))
      .provideEnvironment(r)
    def describeReservedNodeExchangeStatusPaginated(
        request: DescribeReservedNodeExchangeStatusRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest,
      DescribeReservedNodeExchangeStatusResponse
    ](
      "describeReservedNodeExchangeStatus",
      api.describeReservedNodeExchangeStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.wrap
      )
      .provideEnvironment(r)
    def modifyClusterParameterGroup(
        request: ModifyClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest,
      ModifyClusterParameterGroupResponse
    ]("modifyClusterParameterGroup", api.modifyClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def revokeSnapshotAccess(request: RevokeSnapshotAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest,
      RevokeSnapshotAccessResponse
    ]("revokeSnapshotAccess", api.revokeSnapshotAccess)(request.buildAwsValue())
      .map(zio.aws.redshift.model.RevokeSnapshotAccessResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(request: CreateEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def modifyClusterMaintenance(request: ModifyClusterMaintenanceRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest,
      ModifyClusterMaintenanceResponse
    ]("modifyClusterMaintenance", api.modifyClusterMaintenance)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterMaintenanceResponse.wrap)
      .provideEnvironment(r)
    def createUsageLimit(
        request: CreateUsageLimitRequest
    ): IO[AwsError, zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest,
        CreateUsageLimitResponse
      ]("createUsageLimit", api.createUsageLimit)(request.buildAwsValue())
        .map(zio.aws.redshift.model.CreateUsageLimitResponse.wrap)
        .provideEnvironment(r)
    def modifySnapshotCopyRetentionPeriod(
        request: ModifySnapshotCopyRetentionPeriodRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest,
      ModifySnapshotCopyRetentionPeriodResponse
    ](
      "modifySnapshotCopyRetentionPeriod",
      api.modifySnapshotCopyRetentionPeriod
    )(request.buildAwsValue())
      .map(
        zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.wrap
      )
      .provideEnvironment(r)
    def deauthorizeDataShare(request: DeauthorizeDataShareRequest): IO[
      AwsError,
      zio.aws.redshift.model.DeauthorizeDataShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest,
      DeauthorizeDataShareResponse
    ]("deauthorizeDataShare", api.deauthorizeDataShare)(request.buildAwsValue())
      .map(zio.aws.redshift.model.DeauthorizeDataShareResponse.wrap)
      .provideEnvironment(r)
    def rotateEncryptionKey(request: RotateEncryptionKeyRequest): IO[
      AwsError,
      zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest,
      RotateEncryptionKeyResponse
    ]("rotateEncryptionKey", api.rotateEncryptionKey)(request.buildAwsValue())
      .map(zio.aws.redshift.model.RotateEncryptionKeyResponse.wrap)
      .provideEnvironment(r)
    def describeEndpointAuthorization(
        request: DescribeEndpointAuthorizationRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.EndpointAuthorization.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest,
      EndpointAuthorization,
      DescribeEndpointAuthorizationPublisher
    ](
      "describeEndpointAuthorization",
      api.describeEndpointAuthorizationPaginator,
      _.endpointAuthorizationList()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.EndpointAuthorization.wrap(item))
      .provideEnvironment(r)
    def describeEndpointAuthorizationPaginated(
        request: DescribeEndpointAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest,
      DescribeEndpointAuthorizationResponse
    ]("describeEndpointAuthorization", api.describeEndpointAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def describeScheduledActions(
        request: DescribeScheduledActionsRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.ScheduledAction.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest,
        ScheduledAction,
        DescribeScheduledActionsPublisher
      ](
        "describeScheduledActions",
        api.describeScheduledActionsPaginator,
        _.scheduledActions()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.ScheduledAction.wrap(item))
        .provideEnvironment(r)
    def describeScheduledActionsPaginated(
        request: DescribeScheduledActionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest,
      DescribeScheduledActionsResponse
    ]("describeScheduledActions", api.describeScheduledActions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeScheduledActionsResponse.wrap)
      .provideEnvironment(r)
    def modifyClusterIamRoles(request: ModifyClusterIamRolesRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest,
      ModifyClusterIamRolesResponse
    ]("modifyClusterIamRoles", api.modifyClusterIamRoles)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyClusterIamRolesResponse.wrap)
      .provideEnvironment(r)
    def deleteScheduledAction(
        request: DeleteScheduledActionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteScheduledActionRequest,
      DeleteScheduledActionResponse
    ]("deleteScheduledAction", api.deleteScheduledAction)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getClusterCredentials(request: GetClusterCredentialsRequest): IO[
      AwsError,
      zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest,
      GetClusterCredentialsResponse
    ]("getClusterCredentials", api.getClusterCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.GetClusterCredentialsResponse.wrap)
      .provideEnvironment(r)
    def rejectDataShare(
        request: RejectDataShareRequest
    ): IO[AwsError, zio.aws.redshift.model.RejectDataShareResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.RejectDataShareRequest,
        RejectDataShareResponse
      ]("rejectDataShare", api.rejectDataShare)(request.buildAwsValue())
        .map(zio.aws.redshift.model.RejectDataShareResponse.wrap)
        .provideEnvironment(r)
    def describeEventSubscriptions(
        request: DescribeEventSubscriptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.EventSubscription.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest,
      EventSubscription,
      DescribeEventSubscriptionsPublisher
    ](
      "describeEventSubscriptions",
      api.describeEventSubscriptionsPaginator,
      _.eventSubscriptionsList()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.EventSubscription.wrap(item))
      .provideEnvironment(r)
    def describeEventSubscriptionsPaginated(
        request: DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeEventSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteAuthenticationProfile(
        request: DeleteAuthenticationProfileRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest,
      DeleteAuthenticationProfileResponse
    ]("deleteAuthenticationProfile", api.deleteAuthenticationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DeleteAuthenticationProfileResponse.wrap)
      .provideEnvironment(r)
    def createClusterParameterGroup(
        request: CreateClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest,
      CreateClusterParameterGroupResponse
    ]("createClusterParameterGroup", api.createClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def createClusterSnapshot(request: CreateClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest,
      CreateClusterSnapshotResponse
    ]("createClusterSnapshot", api.createClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshotSchedules(
        request: DescribeSnapshotSchedulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.SnapshotSchedule.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest,
      SnapshotSchedule,
      DescribeSnapshotSchedulesPublisher
    ](
      "describeSnapshotSchedules",
      api.describeSnapshotSchedulesPaginator,
      _.snapshotSchedules()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.SnapshotSchedule.wrap(item))
      .provideEnvironment(r)
    def describeSnapshotSchedulesPaginated(
        request: DescribeSnapshotSchedulesRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest,
      DescribeSnapshotSchedulesResponse
    ]("describeSnapshotSchedules", api.describeSnapshotSchedules)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.wrap)
      .provideEnvironment(r)
    def describeClusterSubnetGroups(
        request: DescribeClusterSubnetGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest,
      ClusterSubnetGroup,
      DescribeClusterSubnetGroupsPublisher
    ](
      "describeClusterSubnetGroups",
      api.describeClusterSubnetGroupsPaginator,
      _.clusterSubnetGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ClusterSubnetGroup.wrap(item))
      .provideEnvironment(r)
    def describeClusterSubnetGroupsPaginated(
        request: DescribeClusterSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest,
      DescribeClusterSubnetGroupsResponse
    ]("describeClusterSubnetGroups", api.describeClusterSubnetGroups)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.wrap)
      .provideEnvironment(r)
    def createClusterSubnetGroup(request: CreateClusterSubnetGroupRequest): IO[
      AwsError,
      zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest,
      CreateClusterSubnetGroupResponse
    ]("createClusterSubnetGroup", api.createClusterSubnetGroup)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.CreateClusterSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyAuthenticationProfile(
        request: ModifyAuthenticationProfileRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest,
      ModifyAuthenticationProfileResponse
    ]("modifyAuthenticationProfile", api.modifyAuthenticationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifyAuthenticationProfileResponse.wrap)
      .provideEnvironment(r)
    def describeDataSharesForProducer(
        request: DescribeDataSharesForProducerRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest,
        DataShare,
        DescribeDataSharesForProducerPublisher
      ](
        "describeDataSharesForProducer",
        api.describeDataSharesForProducerPaginator,
        _.dataShares()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.DataShare.wrap(item))
        .provideEnvironment(r)
    def describeDataSharesForProducerPaginated(
        request: DescribeDataSharesForProducerRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest,
      DescribeDataSharesForProducerResponse
    ]("describeDataSharesForProducer", api.describeDataSharesForProducer)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeDataSharesForProducerResponse.wrap)
      .provideEnvironment(r)
    def describeReservedNodeOfferings(
        request: DescribeReservedNodeOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest,
      ReservedNodeOffering,
      DescribeReservedNodeOfferingsPublisher
    ](
      "describeReservedNodeOfferings",
      api.describeReservedNodeOfferingsPaginator,
      _.reservedNodeOfferings()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.ReservedNodeOffering.wrap(item))
      .provideEnvironment(r)
    def describeReservedNodeOfferingsPaginated(
        request: DescribeReservedNodeOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest,
      DescribeReservedNodeOfferingsResponse
    ]("describeReservedNodeOfferings", api.describeReservedNodeOfferings)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.wrap)
      .provideEnvironment(r)
    def modifySnapshotSchedule(request: ModifySnapshotScheduleRequest): IO[
      AwsError,
      zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest,
      ModifySnapshotScheduleResponse
    ]("modifySnapshotSchedule", api.modifySnapshotSchedule)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.ModifySnapshotScheduleResponse.wrap)
      .provideEnvironment(r)
    def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DeleteTagsRequest,
        DeleteTagsResponse
      ]("deleteTags", api.deleteTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def purchaseReservedNodeOffering(
        request: PurchaseReservedNodeOfferingRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest,
      PurchaseReservedNodeOfferingResponse
    ]("purchaseReservedNodeOffering", api.purchaseReservedNodeOffering)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAttributes(
        request: DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeAccountAttributesResponse.wrap)
      .provideEnvironment(r)
    def batchModifyClusterSnapshots(
        request: BatchModifyClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest,
      BatchModifyClusterSnapshotsResponse
    ]("batchModifyClusterSnapshots", api.batchModifyClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def deleteClusterSubnetGroup(
        request: DeleteClusterSubnetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest,
      DeleteClusterSubnetGroupResponse
    ]("deleteClusterSubnetGroup", api.deleteClusterSubnetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def revokeClusterSecurityGroupIngress(
        request: RevokeClusterSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest,
      RevokeClusterSecurityGroupIngressResponse
    ](
      "revokeClusterSecurityGroupIngress",
      api.revokeClusterSecurityGroupIngress
    )(request.buildAwsValue())
      .map(
        zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.wrap
      )
      .provideEnvironment(r)
    def authorizeClusterSecurityGroupIngress(
        request: AuthorizeClusterSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest,
      AuthorizeClusterSecurityGroupIngressResponse
    ](
      "authorizeClusterSecurityGroupIngress",
      api.authorizeClusterSecurityGroupIngress
    )(request.buildAwsValue())
      .map(
        zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.wrap
      )
      .provideEnvironment(r)
    def updatePartnerStatus(request: UpdatePartnerStatusRequest): IO[
      AwsError,
      zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest,
      UpdatePartnerStatusResponse
    ]("updatePartnerStatus", api.updatePartnerStatus)(request.buildAwsValue())
      .map(zio.aws.redshift.model.UpdatePartnerStatusResponse.wrap)
      .provideEnvironment(r)
    def copyClusterSnapshot(request: CopyClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest,
      CopyClusterSnapshotResponse
    ]("copyClusterSnapshot", api.copyClusterSnapshot)(request.buildAwsValue())
      .map(zio.aws.redshift.model.CopyClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshotCopyGrants(
        request: DescribeSnapshotCopyGrantsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest,
      SnapshotCopyGrant,
      DescribeSnapshotCopyGrantsPublisher
    ](
      "describeSnapshotCopyGrants",
      api.describeSnapshotCopyGrantsPaginator,
      _.snapshotCopyGrants()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshift.model.SnapshotCopyGrant.wrap(item))
      .provideEnvironment(r)
    def describeSnapshotCopyGrantsPaginated(
        request: DescribeSnapshotCopyGrantsRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest,
      DescribeSnapshotCopyGrantsResponse
    ]("describeSnapshotCopyGrants", api.describeSnapshotCopyGrants)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.wrap)
      .provideEnvironment(r)
    def authorizeEndpointAccess(request: AuthorizeEndpointAccessRequest): IO[
      AwsError,
      zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest,
      AuthorizeEndpointAccessResponse
    ]("authorizeEndpointAccess", api.authorizeEndpointAccess)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.AuthorizeEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def restoreFromClusterSnapshot(
        request: RestoreFromClusterSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest,
      RestoreFromClusterSnapshotResponse
    ]("restoreFromClusterSnapshot", api.restoreFromClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def disableLogging(
        request: DisableLoggingRequest
    ): IO[AwsError, zio.aws.redshift.model.DisableLoggingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DisableLoggingRequest,
        DisableLoggingResponse
      ]("disableLogging", api.disableLogging)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DisableLoggingResponse.wrap)
        .provideEnvironment(r)
    def disassociateDataShareConsumer(
        request: DisassociateDataShareConsumerRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DisassociateDataShareConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest,
      DisassociateDataShareConsumerResponse
    ]("disassociateDataShareConsumer", api.disassociateDataShareConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DisassociateDataShareConsumerResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.Event.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeEventsRequest,
        Event,
        DescribeEventsPublisher
      ]("describeEvents", api.describeEventsPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.redshift.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.redshift.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.redshift.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def describeEndpointAccess(
        request: DescribeEndpointAccessRequest
    ): ZStream[Any, AwsError, zio.aws.redshift.model.EndpointAccess.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest,
        EndpointAccess,
        DescribeEndpointAccessPublisher
      ](
        "describeEndpointAccess",
        api.describeEndpointAccessPaginator,
        _.endpointAccessList()
      )(request.buildAwsValue())
        .map(item => zio.aws.redshift.model.EndpointAccess.wrap(item))
        .provideEnvironment(r)
    def describeEndpointAccessPaginated(
        request: DescribeEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest,
      DescribeEndpointAccessResponse
    ]("describeEndpointAccess", api.describeEndpointAccess)(
      request.buildAwsValue()
    ).map(zio.aws.redshift.model.DescribeEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def createTags(request: CreateTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.redshift.model.CreateTagsRequest,
        CreateTagsResponse
      ]("createTags", api.createTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
  }
  def deleteHsmConfiguration(
      request: DeleteHsmConfigurationRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteHsmConfiguration(request))
  def authorizeSnapshotAccess(request: AuthorizeSnapshotAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeSnapshotAccess(request))
  def describeTags(request: DescribeTagsRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.TaggedResource.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTags(request))
  def describeTagsPaginated(request: DescribeTagsRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTagsPaginated(request))
  def modifyClusterSubnetGroup(request: ModifyClusterSubnetGroupRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterSubnetGroup(request))
  def resetClusterParameterGroup(
      request: ResetClusterParameterGroupRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetClusterParameterGroup(request))
  def deleteClusterParameterGroup(
      request: DeleteClusterParameterGroupRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteClusterParameterGroup(request))
  def resumeCluster(request: ResumeClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ResumeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resumeCluster(request))
  def describeClusters(request: DescribeClustersRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.Cluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusters(request))
  def describeClustersPaginated(request: DescribeClustersRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClustersPaginated(request))
  def modifyUsageLimit(request: ModifyUsageLimitRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyUsageLimit(request))
  def describeClusterDbRevisions(
      request: DescribeClusterDbRevisionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ClusterDbRevision.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterDbRevisions(request))
  def describeClusterDbRevisionsPaginated(
      request: DescribeClusterDbRevisionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterDbRevisionsPaginated(request))
  def acceptReservedNodeExchange(
      request: AcceptReservedNodeExchangeRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptReservedNodeExchange(request))
  def modifyScheduledAction(request: ModifyScheduledActionRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyScheduledActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyScheduledAction(request))
  def getReservedNodeExchangeConfigurationOptions(
      request: GetReservedNodeExchangeConfigurationOptionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getReservedNodeExchangeConfigurationOptions(request)
  )
  def getReservedNodeExchangeConfigurationOptionsPaginated(
      request: GetReservedNodeExchangeConfigurationOptionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getReservedNodeExchangeConfigurationOptionsPaginated(request)
  )
  def describeDefaultClusterParameters(
      request: DescribeDefaultClusterParametersRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDefaultClusterParameters(request))
  def modifyEndpointAccess(request: ModifyEndpointAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEndpointAccess(request))
  def createClusterSecurityGroup(
      request: CreateClusterSecurityGroupRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClusterSecurityGroup(request))
  def batchDeleteClusterSnapshots(
      request: BatchDeleteClusterSnapshotsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteClusterSnapshots(request))
  def createAuthenticationProfile(
      request: CreateAuthenticationProfileRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAuthenticationProfile(request))
  def deleteHsmClientCertificate(
      request: DeleteHsmClientCertificateRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteHsmClientCertificate(request))
  def describeClusterParameterGroups(
      request: DescribeClusterParameterGroupsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterParameterGroups(request))
  def describeClusterParameterGroupsPaginated(
      request: DescribeClusterParameterGroupsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterParameterGroupsPaginated(request))
  def describeReservedNodes(request: DescribeReservedNodesRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ReservedNode.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedNodes(request))
  def describeReservedNodesPaginated(
      request: DescribeReservedNodesRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedNodesPaginated(request))
  def disableSnapshotCopy(request: DisableSnapshotCopyRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableSnapshotCopy(request))
  def enableSnapshotCopy(request: EnableSnapshotCopyRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.EnableSnapshotCopyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableSnapshotCopy(request))
  def describeClusterVersions(request: DescribeClusterVersionsRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ClusterVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterVersions(request))
  def describeClusterVersionsPaginated(
      request: DescribeClusterVersionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterVersionsPaginated(request))
  def modifyClusterSnapshotSchedule(
      request: ModifyClusterSnapshotScheduleRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyClusterSnapshotSchedule(request))
  def deleteSnapshotCopyGrant(
      request: DeleteSnapshotCopyGrantRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSnapshotCopyGrant(request))
  def modifyAquaConfiguration(request: ModifyAquaConfigurationRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyAquaConfiguration(request))
  def describeClusterTracks(request: DescribeClusterTracksRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.MaintenanceTrack.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterTracks(request))
  def describeClusterTracksPaginated(
      request: DescribeClusterTracksRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterTracksPaginated(request))
  def createHsmConfiguration(request: CreateHsmConfigurationRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHsmConfiguration(request))
  def describeDataSharesForConsumer(
      request: DescribeDataSharesForConsumerRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DataShare.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataSharesForConsumer(request))
  def describeDataSharesForConsumerPaginated(
      request: DescribeDataSharesForConsumerRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataSharesForConsumerPaginated(request))
  def deleteEventSubscription(
      request: DeleteEventSubscriptionRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def modifyClusterSnapshot(request: ModifyClusterSnapshotRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterSnapshot(request))
  def restoreTableFromClusterSnapshot(
      request: RestoreTableFromClusterSnapshotRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreTableFromClusterSnapshot(request))
  def describeUsageLimits(request: DescribeUsageLimitsRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.UsageLimit.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsageLimits(request))
  def describeUsageLimitsPaginated(request: DescribeUsageLimitsRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsageLimitsPaginated(request))
  def describeResize(request: DescribeResizeRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeResizeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResize(request))
  def deleteSnapshotSchedule(
      request: DeleteSnapshotScheduleRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSnapshotSchedule(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def associateDataShareConsumer(
      request: AssociateDataShareConsumerRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AssociateDataShareConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDataShareConsumer(request))
  def deleteClusterSnapshot(request: DeleteClusterSnapshotRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteClusterSnapshot(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def deleteUsageLimit(
      request: DeleteUsageLimitRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUsageLimit(request))
  def cancelResize(request: CancelResizeRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CancelResizeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelResize(request))
  def pauseCluster(request: PauseClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.PauseClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pauseCluster(request))
  def deleteEndpointAccess(request: DeleteEndpointAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpointAccess(request))
  def resizeCluster(request: ResizeClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ResizeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resizeCluster(request))
  def describeClusterSecurityGroups(
      request: DescribeClusterSecurityGroupsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterSecurityGroups(request))
  def describeClusterSecurityGroupsPaginated(
      request: DescribeClusterSecurityGroupsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterSecurityGroupsPaginated(request))
  def createSnapshotCopyGrant(request: CreateSnapshotCopyGrantRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshotCopyGrant(request))
  def describeHsmConfigurations(
      request: DescribeHsmConfigurationsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.HsmConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.describeHsmConfigurations(request))
  def describeHsmConfigurationsPaginated(
      request: DescribeHsmConfigurationsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHsmConfigurationsPaginated(request))
  def describeClusterParameters(
      request: DescribeClusterParametersRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterParameters(request))
  def describeClusterParametersPaginated(
      request: DescribeClusterParametersRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterParametersPaginated(request))
  def createEndpointAccess(request: CreateEndpointAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpointAccess(request))
  def addPartner(request: AddPartnerRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AddPartnerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addPartner(request))
  def describeOrderableClusterOptions(
      request: DescribeOrderableClusterOptionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.OrderableClusterOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrderableClusterOptions(request))
  def describeOrderableClusterOptionsPaginated(
      request: DescribeOrderableClusterOptionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableClusterOptionsPaginated(request))
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def describeLoggingStatus(request: DescribeLoggingStatusRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeLoggingStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoggingStatus(request))
  def createHsmClientCertificate(
      request: CreateHsmClientCertificateRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHsmClientCertificate(request))
  def deletePartner(request: DeletePartnerRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeletePartnerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePartner(request))
  def describeNodeConfigurationOptions(
      request: DescribeNodeConfigurationOptionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNodeConfigurationOptions(request))
  def describeNodeConfigurationOptionsPaginated(
      request: DescribeNodeConfigurationOptionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNodeConfigurationOptionsPaginated(request))
  def describeTableRestoreStatus(
      request: DescribeTableRestoreStatusRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.TableRestoreStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTableRestoreStatus(request))
  def describeTableRestoreStatusPaginated(
      request: DescribeTableRestoreStatusRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTableRestoreStatusPaginated(request))
  def rebootCluster(request: RebootClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RebootClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootCluster(request))
  def enableLogging(request: EnableLoggingRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.EnableLoggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableLogging(request))
  def revokeEndpointAccess(request: RevokeEndpointAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeEndpointAccess(request))
  def describeAuthenticationProfiles(
      request: DescribeAuthenticationProfilesRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAuthenticationProfiles(request))
  def createScheduledAction(request: CreateScheduledActionRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScheduledAction(request))
  def deleteClusterSecurityGroup(
      request: DeleteClusterSecurityGroupRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteClusterSecurityGroup(request))
  def describePartners(request: DescribePartnersRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribePartnersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePartners(request))
  def describeHsmClientCertificates(
      request: DescribeHsmClientCertificatesRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.HsmClientCertificate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeHsmClientCertificates(request))
  def describeHsmClientCertificatesPaginated(
      request: DescribeHsmClientCertificatesRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHsmClientCertificatesPaginated(request))
  def describeEventCategories(request: DescribeEventCategoriesRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def modifyClusterDbRevision(request: ModifyClusterDbRevisionRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterDbRevision(request))
  def createSnapshotSchedule(request: CreateSnapshotScheduleRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshotSchedule(request))
  def describeDataShares(request: DescribeDataSharesRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DataShare.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataShares(request))
  def describeDataSharesPaginated(request: DescribeDataSharesRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataSharesPaginated(request))
  def describeClusterSnapshots(
      request: DescribeClusterSnapshotsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.Snapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterSnapshots(request))
  def describeClusterSnapshotsPaginated(
      request: DescribeClusterSnapshotsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterSnapshotsPaginated(request))
  def getReservedNodeExchangeOfferings(
      request: GetReservedNodeExchangeOfferingsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.getReservedNodeExchangeOfferings(request))
  def getReservedNodeExchangeOfferingsPaginated(
      request: GetReservedNodeExchangeOfferingsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReservedNodeExchangeOfferingsPaginated(request))
  def describeStorage(): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorage())
  def modifyCluster(request: ModifyClusterRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCluster(request))
  def authorizeDataShare(request: AuthorizeDataShareRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeDataShare(request))
  def describeReservedNodeExchangeStatus(
      request: DescribeReservedNodeExchangeStatusRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedNodeExchangeStatus(request))
  def describeReservedNodeExchangeStatusPaginated(
      request: DescribeReservedNodeExchangeStatusRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedNodeExchangeStatusPaginated(request))
  def modifyClusterParameterGroup(
      request: ModifyClusterParameterGroupRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterParameterGroup(request))
  def revokeSnapshotAccess(request: RevokeSnapshotAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeSnapshotAccess(request))
  def createEventSubscription(request: CreateEventSubscriptionRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSubscription(request))
  def modifyClusterMaintenance(request: ModifyClusterMaintenanceRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterMaintenance(request))
  def createUsageLimit(request: CreateUsageLimitRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUsageLimit(request))
  def modifySnapshotCopyRetentionPeriod(
      request: ModifySnapshotCopyRetentionPeriodRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySnapshotCopyRetentionPeriod(request))
  def deauthorizeDataShare(request: DeauthorizeDataShareRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeauthorizeDataShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deauthorizeDataShare(request))
  def rotateEncryptionKey(request: RotateEncryptionKeyRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rotateEncryptionKey(request))
  def describeEndpointAuthorization(
      request: DescribeEndpointAuthorizationRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.EndpointAuthorization.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEndpointAuthorization(request))
  def describeEndpointAuthorizationPaginated(
      request: DescribeEndpointAuthorizationRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointAuthorizationPaginated(request))
  def describeScheduledActions(
      request: DescribeScheduledActionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ScheduledAction.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScheduledActions(request))
  def describeScheduledActionsPaginated(
      request: DescribeScheduledActionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScheduledActionsPaginated(request))
  def modifyClusterIamRoles(request: ModifyClusterIamRolesRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClusterIamRoles(request))
  def deleteScheduledAction(
      request: DeleteScheduledActionRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteScheduledAction(request))
  def getClusterCredentials(request: GetClusterCredentialsRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getClusterCredentials(request))
  def rejectDataShare(request: RejectDataShareRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RejectDataShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectDataShare(request))
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.EventSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventSubscriptions(request))
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptionsPaginated(request))
  def deleteAuthenticationProfile(
      request: DeleteAuthenticationProfileRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAuthenticationProfile(request))
  def createClusterParameterGroup(
      request: CreateClusterParameterGroupRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClusterParameterGroup(request))
  def createClusterSnapshot(request: CreateClusterSnapshotRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClusterSnapshot(request))
  def describeSnapshotSchedules(
      request: DescribeSnapshotSchedulesRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.SnapshotSchedule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSnapshotSchedules(request))
  def describeSnapshotSchedulesPaginated(
      request: DescribeSnapshotSchedulesRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotSchedulesPaginated(request))
  def describeClusterSubnetGroups(
      request: DescribeClusterSubnetGroupsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClusterSubnetGroups(request))
  def describeClusterSubnetGroupsPaginated(
      request: DescribeClusterSubnetGroupsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterSubnetGroupsPaginated(request))
  def createClusterSubnetGroup(request: CreateClusterSubnetGroupRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClusterSubnetGroup(request))
  def modifyAuthenticationProfile(
      request: ModifyAuthenticationProfileRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyAuthenticationProfile(request))
  def describeDataSharesForProducer(
      request: DescribeDataSharesForProducerRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DataShare.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataSharesForProducer(request))
  def describeDataSharesForProducerPaginated(
      request: DescribeDataSharesForProducerRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeDataSharesForProducerPaginated(request))
  def describeReservedNodeOfferings(
      request: DescribeReservedNodeOfferingsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedNodeOfferings(request))
  def describeReservedNodeOfferingsPaginated(
      request: DescribeReservedNodeOfferingsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedNodeOfferingsPaginated(request))
  def modifySnapshotSchedule(request: ModifySnapshotScheduleRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySnapshotSchedule(request))
  def deleteTags(
      request: DeleteTagsRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTags(request))
  def purchaseReservedNodeOffering(
      request: PurchaseReservedNodeOfferingRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseReservedNodeOffering(request))
  def describeAccountAttributes(request: DescribeAccountAttributesRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def batchModifyClusterSnapshots(
      request: BatchModifyClusterSnapshotsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchModifyClusterSnapshots(request))
  def deleteClusterSubnetGroup(
      request: DeleteClusterSubnetGroupRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteClusterSubnetGroup(request))
  def revokeClusterSecurityGroupIngress(
      request: RevokeClusterSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeClusterSecurityGroupIngress(request))
  def authorizeClusterSecurityGroupIngress(
      request: AuthorizeClusterSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeClusterSecurityGroupIngress(request))
  def updatePartnerStatus(request: UpdatePartnerStatusRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePartnerStatus(request))
  def copyClusterSnapshot(request: CopyClusterSnapshotRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyClusterSnapshot(request))
  def describeSnapshotCopyGrants(
      request: DescribeSnapshotCopyGrantsRequest
  ): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSnapshotCopyGrants(request))
  def describeSnapshotCopyGrantsPaginated(
      request: DescribeSnapshotCopyGrantsRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotCopyGrantsPaginated(request))
  def authorizeEndpointAccess(request: AuthorizeEndpointAccessRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeEndpointAccess(request))
  def restoreFromClusterSnapshot(
      request: RestoreFromClusterSnapshotRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreFromClusterSnapshot(request))
  def disableLogging(request: DisableLoggingRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DisableLoggingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableLogging(request))
  def disassociateDataShareConsumer(
      request: DisassociateDataShareConsumerRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DisassociateDataShareConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateDataShareConsumer(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def describeEndpointAccess(request: DescribeEndpointAccessRequest): ZStream[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.EndpointAccess.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEndpointAccess(request))
  def describeEndpointAccessPaginated(
      request: DescribeEndpointAccessRequest
  ): ZIO[
    zio.aws.redshift.Redshift,
    AwsError,
    zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointAccessPaginated(request))
  def createTags(
      request: CreateTagsRequest
  ): ZIO[zio.aws.redshift.Redshift, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createTags(request))
}
