package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTarget(
    maintenanceTrackName: Optional[String] = Optional.Absent,
    databaseVersion: Optional[String] = Optional.Absent,
    supportedOperations: Optional[
      Iterable[zio.aws.redshift.model.SupportedOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.UpdateTarget = {
    import UpdateTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.UpdateTarget
      .builder()
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(databaseVersion.map(value => value: java.lang.String))(
        _.databaseVersion
      )
      .optionallyWith(
        supportedOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedOperations)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.UpdateTarget.ReadOnly =
    zio.aws.redshift.model.UpdateTarget.wrap(buildAwsValue())
}
object UpdateTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.UpdateTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.UpdateTarget =
      zio.aws.redshift.model.UpdateTarget(
        maintenanceTrackName.map(value => value),
        databaseVersion.map(value => value),
        supportedOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maintenanceTrackName: Optional[String]
    def databaseVersion: Optional[String]
    def supportedOperations
        : Optional[List[zio.aws.redshift.model.SupportedOperation.ReadOnly]]
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getDatabaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseVersion", databaseVersion)
    def getSupportedOperations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SupportedOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("supportedOperations", supportedOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.UpdateTarget
  ) extends zio.aws.redshift.model.UpdateTarget.ReadOnly {
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val databaseVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseVersion())
      .map(value => value: String)
    override val supportedOperations
        : Optional[List[zio.aws.redshift.model.SupportedOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SupportedOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.UpdateTarget
  ): zio.aws.redshift.model.UpdateTarget.ReadOnly = new Wrapper(impl)
}
